package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneSearchProvider;
import org.eaglei.search.provider.ncbi.mesh.NCBIMeSHSearchProvider;
import org.eaglei.search.provider.ncbi.probe.NCBIProbeSearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedSearchProvider;
import org.eaglei.search.provider.ncbi.taxonomy.NCBITaxonomySearchProvider;
import org.eaglei.services.InstitutionRegistry;

/**
 * SearchProvider implementation for querying multiple NCBISearchProviders
 *
 * @author rfrost
 */
public class NCBISearchProviderSet implements SearchProvider {

    private static final Log logger = LogFactory.getLog(NCBISearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
        
    private final List<NCBISearchProvider> providers = new ArrayList<NCBISearchProvider>();
    
    /**
     * Creates a new SearchProvider that executes queries against NCBI.
     */
    public NCBISearchProviderSet(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        assert eagleiOntModel != null;
        assert registry != null;
        this.providers.add(new NCBIProbeSearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBIPubMedSearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBITaxonomySearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBIGeneSearchProvider(eagleiOntModel, registry));        
        this.providers.add(new NCBIMeSHSearchProvider(eagleiOntModel, registry));        
    }
    
    /* (non-Javadoc)
     * @see org.eaglei.search.provider.SearchProvider#init()
     */
    public void init() throws IOException {
        // no-op
    }
    
    /* (non-Javadoc)
     * @see org.eaglei.search.provider.SearchProvider#query(org.eaglei.search.request.SearchRequest)
     */
    public SearchResultSet query(final SearchRequest request) throws IOException {
        assert request != null;
        
        final SearchResultSet results = new SearchResultSet(request);

        for (NCBISearchProvider provider: providers) {
            if (provider.shouldAddResults(request)) {
                //provider.addNCBIResults(results);
            }
        }
        
        return results;
    }

    /* (non-Javadoc)
     * @see org.eaglei.search.provider.SearchProvider#count(org.eaglei.search.provider.SearchCountRequest)
     */
    public SearchCounts count(SearchCountRequest request) throws IOException {
        // TODO return empty counts for now
        return new SearchCounts(request.getRequest());     
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }    
}
