package org.eaglei.search.provider.ncbi.pubmed;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedProvider.PubMedSummary;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBIPubMedProvider.
 *
 * @author rfrost
 */
public final class NCBIPubMedSearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBIPubMedProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static final String DOCUMENT_URI = "http://purl.obolibrary.org/obo/IAO_0000310";
    private final EIEntity docEntity;
    public static final String PUBLICATION_URI = "http://purl.obolibrary.org/obo/IAO_0000311";
    private final EIEntity pubEntity;   
    private final EIEntity locationEntity;
    
    private static final EIURI JOURNAL_URI = EIURI.create("journal");
    private static final EIURI DATE_URI = EIURI.create("date");

    public NCBIPubMedSearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBIPubMedProvider(), eagleiOntModel, registry);
        this.docEntity = eagleiOntModel.getClass(EIURI.create(DOCUMENT_URI)).getEntity();        
        this.pubEntity = eagleiOntModel.getClass(EIURI.create(PUBLICATION_URI)).getEntity();  
        this.locationEntity = EIEntity.create(EIURI.create(NCBIPubMedProvider.PUBMED_URL), NCBIPubMedProvider.NCBI_PUBMED_NAME);        
    }    
    
    public EIEntity getType() {
        return pubEntity;
    }
    
    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        return true;
        /*
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, this.docEntity.getURI()) && request.getTerm() != null;
        */
    }    
    
    @Override
    protected SearchResult createSearchResultForDocSummary(ESummaryResult sum)
            throws IOException {
        final PubMedSummary pubMedSum = new PubMedSummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(pubMedSum.url, pubMedSum.label), pubEntity, null, locationEntity);
        searchResult.setURL(pubMedSum.url);
        searchResult.addDataTypeProperty(JOURNAL_URI, sum.items.get(NCBIPubMedProvider.FULL_JOURNAL_NAME).get(0).value);
        // Trim any stuff beyond the first ; in the date string.
        String date = sum.items.get(NCBIPubMedProvider.SO).get(0).value;
        int dateend = date.indexOf(';');
        if (dateend != -1) {
        	date = date.substring(0, dateend);
        }
        searchResult.addDataTypeProperty(DATE_URI, date);
        
        return searchResult;
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, false, Collections.EMPTY_SET, true);
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }   
    
}
