/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneSearchProvider;
import org.eaglei.search.provider.ncbi.mesh.NCBIMeSHSearchProvider;
import org.eaglei.search.provider.ncbi.probe.NCBIProbeSearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedSearchProvider;
import org.eaglei.search.provider.ncbi.taxonomy.NCBITaxonomySearchProvider;
import org.eaglei.services.InstitutionRegistry;

public class NCBISearchProviderSet
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(NCBISearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private final List<NCBISearchProvider> providers = new ArrayList<NCBISearchProvider>();

    public NCBISearchProviderSet(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        assert (eagleiOntModel != null);
        assert (registry != null);
        this.providers.add(new NCBIProbeSearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBIPubMedSearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBITaxonomySearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBIGeneSearchProvider(eagleiOntModel, registry));
        this.providers.add(new NCBIMeSHSearchProvider(eagleiOntModel, registry));
    }

    public void init() throws IOException {
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        assert (request != null);
        SearchResultSet results = new SearchResultSet(request);
        for (NCBISearchProvider provider : this.providers) {
            if (!provider.shouldAddResults(request)) continue;
        }
        return results;
    }

    public SearchCounts count(SearchCountRequest request) throws IOException {
        return new SearchCounts(request.getRequest());
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }
}

