package org.eaglei.search.provider.ncbi.mesh;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.mesh.NCBIMeSHProvider.MeSHSummary;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBIMeSHProvider. 
 *
 * @author rfrost
 */
public final class NCBIMeSHSearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBIMeSHSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
        
    public static final String DISEASE_URI = "http://purl.obolibrary.org/obo/OBI_1110055";
    private final EIEntity diseaseEntity;        
    private final EIEntity meshEntity;       
    private final EIEntity locationEntity;        
    
    public NCBIMeSHSearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBIMeSHProvider(), eagleiOntModel, registry);
        this.diseaseEntity = eagleiOntModel.getClass(EIURI.create(DISEASE_URI)).getEntity();        
        this.meshEntity = EIEntity.create(EIURI.create(NCBIMeSHProvider.MESH_URL), "MeSH");
        this.locationEntity = EIEntity.create(EIURI.create(NCBIMeSHProvider.MESH_URL), NCBIMeSHProvider.NCBI_MESH_NAME);        
    }
    
    public EIEntity getType() {
        return meshEntity;
    }    

    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        return true;
        /*
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, diseaseEntity.getURI());
        */
    }

    @Override
    protected SearchResult createSearchResultForDocSummary(ESummaryResult sum)
            throws IOException {
        final MeSHSummary meshSum = new MeSHSummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(meshSum.url, meshSum.label), meshEntity, null, locationEntity);
        searchResult.setURL(meshSum.url);
        searchResult.setHighlight(meshSum.scopeNote.value);
        return searchResult;       
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, false, Collections.EMPTY_SET, false);
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }

	@Override
	public ClassCountResult getProviderTypeCount(SearchRequest request) {
		// TODO Auto-generated method stub
		return null;
	}    

}
