package org.eaglei.search.provider.ncbi.gene;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneProvider.GeneSummary;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBIGeneProvider.
 *
 * @author rfrost
 */
public final class NCBIGeneSearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBIGeneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static final String GENE_URI = "http://purl.obolibrary.org/obo/ERO_0000223";
    private final EIEntity entrezGeneEntity;
    private final EIEntity geneEntity;    
    private final EIEntity locationEntity;        
    
    private static final EIURI ORGANISM_URI = EIURI.create("organism");
    private static final EIURI AKA_URI = EIURI.create("aka");
    
    public NCBIGeneSearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBIGeneProvider(), eagleiOntModel, registry);
        this.geneEntity = eagleiOntModel.getClass(EIURI.create(GENE_URI)).getEntity();
        this.entrezGeneEntity = EIEntity.create(EIURI.create(NCBIGeneProvider.GENE_URL), "Entrez Gene");
        this.locationEntity = EIEntity.create(EIURI.create(NCBIGeneProvider.GENE_URL), NCBIGeneProvider.ENTREZ_GENE);
    }
    
    public EIEntity getType() {
        // TODO the old gene entity is now obsolete
        //return geneEntity;
        return entrezGeneEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        return true;
        /*
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, geneEntity.getURI());
        */
    }
     
    @Override
    protected SearchResult createSearchResultForDocSummary(ESummaryResult sum)
            throws IOException {
        final GeneSummary geneSum = new GeneSummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(geneSum.url, geneSum.desc.value), entrezGeneEntity, null, locationEntity);
        searchResult.setURL(geneSum.url);
        searchResult.setHighlight("Official Symbol:  "+geneSum.name.value);
        searchResult.addDataTypeProperty(ORGANISM_URI, geneSum.orgname.value);
        searchResult.addDataTypeProperty(AKA_URI, geneSum.otherAliases != null ? geneSum.otherAliases.value : "");
        return searchResult;
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, false, Collections.EMPTY_SET, false);
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }

	@Override
	public ClassCountResult getProviderTypeCount(SearchRequest request) {
		// TODO Auto-generated method stub
		return null;
	}    

}
