/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.pubmed;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.pubmed.NCBIPubMedProvider;
import org.eaglei.services.InstitutionRegistry;

public final class NCBIPubMedSearchProvider
extends NCBISearchProvider {
    private static final Log logger = LogFactory.getLog(NCBIPubMedProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String DOCUMENT_URI = "http://purl.obolibrary.org/obo/IAO_0000310";
    private final EIEntity docEntity;
    public static final String PUBLICATION_URI = "http://purl.obolibrary.org/obo/IAO_0000311";
    private final EIEntity pubEntity;
    private final EIEntity locationEntity;
    private static final EIURI JOURNAL_URI = EIURI.create((String)"journal");
    private static final EIURI DATE_URI = EIURI.create((String)"date");

    public NCBIPubMedSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        super((NCBIDBProvider)new NCBIPubMedProvider(), eagleiOntModel, registry);
        this.docEntity = eagleiOntModel.getClass(EIURI.create((String)DOCUMENT_URI)).getEntity();
        this.pubEntity = eagleiOntModel.getClass(EIURI.create((String)PUBLICATION_URI)).getEntity();
        this.locationEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/pubmed/"), (String)"NCBI PubMed");
    }

    @Override
    public EIEntity getType() {
        return this.pubEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request) throws IOException {
        return true;
    }

    @Override
    protected SearchResult createSearchResultForDocSummary(ESummary.ESummaryResult sum) throws IOException {
        NCBIPubMedProvider.PubMedSummary pubMedSum = new NCBIPubMedProvider.PubMedSummary(sum);
        SearchResult searchResult = new SearchResult(EIEntity.create((String)pubMedSum.url, (String)pubMedSum.label), this.pubEntity, null, this.locationEntity);
        searchResult.setURL(pubMedSum.url);
        searchResult.addDataTypeProperty(JOURNAL_URI, ((ESummary.Item)((List)sum.items.get((Object)"FullJournalName")).get((int)0)).value);
        String date = ((ESummary.Item)((List)sum.items.get((Object)"SO")).get((int)0)).value;
        int dateend = date.indexOf(59);
        if (dateend != -1) {
            date = date.substring(0, dateend);
        }
        searchResult.addDataTypeProperty(DATE_URI, date);
        return searchResult;
    }

    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return this.getQuery(request, false, Collections.EMPTY_SET, true);
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }

    public ClassCountResult getProviderTypeCount(SearchRequest request) {
        return null;
    }
}

