package org.eaglei.search.provider.ncbi.probe;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBIEUtils.DocSummary;
import org.eaglei.search.provider.ncbi.NCBIEUtils.Item;

/**
 * Contains logic for querying NCBI Probe via EUtils.
 *
 * @author rfrost
 */
public final class NCBIProbeProvider extends NCBIDBProvider {

    private static final Log logger = LogFactory.getLog(NCBIProbeProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
        
    public static final String PROBE_URL = "http://www.ncbi.nlm.nih.gov/genome/probe/reports/probereport.cgi?uid=";
    public static final String PROBE = "probe";
    public static final String NCBI_PROBE_NAME = "NCBI Probe";

    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String PTYPE = "ptype";
    
    public NCBIProbeProvider() {
        super(PROBE);
    }
    
    public static class ProbeSummary {
        public String id;
        public String url;
        public String label;
        public Item name;
        public Item title;
        public Item ptype;
        public ProbeSummary(DocSummary sum) {
            this.id = sum.id;
            this.url = PROBE_URL + id;
            this.ptype = sum.items.get(PTYPE).get(0);
            this.name = sum.items.get(NAME).get(0);
            this.label = name.value + " (" + ptype.value + ")";  
            this.title = sum.items.get(TITLE).get(0);

        }
    }
}
