/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.pubmed;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBIEUtils;

public final class NCBIPubMedProvider
extends NCBIDBProvider {
    private static final Log logger = LogFactory.getLog(NCBIPubMedProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String PUBMED_URL = "http://www.ncbi.nlm.nih.gov/pubmed/";
    public static final String PUBMED = "pubmed";
    public static final String NCBI_PUBMED_NAME = "NCBI PubMed";
    public static final String TITLE = "Title";
    public static final String AUTHOR_LIST = "AuthorList";
    public static final String AUTHOR = "Author";
    public static final String SOURCE = "Source";
    public static final String FULL_JOURNAL_NAME = "FullJournalName";
    public static final String SO = "SO";

    public NCBIPubMedProvider() {
        super(PUBMED);
    }

    public static class PubMedSummary {
        public String pmid;
        public String url;
        public NCBIEUtils.Item journal;
        public NCBIEUtils.Item so;
        public NCBIEUtils.Item title;
        public String descrip;
        public final String label;

        public PubMedSummary(NCBIEUtils.DocSummary sum) {
            this.pmid = sum.id;
            this.url = NCBIPubMedProvider.PUBMED_URL + this.pmid;
            this.journal = sum.items.get(NCBIPubMedProvider.FULL_JOURNAL_NAME).get(0);
            this.so = sum.items.get(NCBIPubMedProvider.SO).get(0);
            this.title = sum.items.get(NCBIPubMedProvider.TITLE).get(0);
            StringBuffer sb = new StringBuffer();
            sb.append(this.journal.value);
            sb.append(". ");
            sb.append(this.so.value);
            this.descrip = sb.toString();
            this.label = this.title.value;
        }
    }
}

