package org.eaglei.search.provider.ncbi.gene;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBIEUtils.DocSummary;
import org.eaglei.search.provider.ncbi.NCBIEUtils.Item;

/**
 * Contains logic for querying NCBI Entrez Gene via EUtils.
 *
 * @author rfrost
 */
public final class NCBIGeneProvider extends NCBIDBProvider {

    private static final Log logger = LogFactory.getLog(NCBIGeneProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
        
    public static final String GENE_URL = "http://www.ncbi.nlm.nih.gov/gene/";
    public static final String GENE = "gene";
    public static final String NAME = "Name";
    public static final String DESC = "Description";
    public static final String OTHER_ALIASES= "OtherAliases";
    public static final String ORGNAME = "Orgname";
    public static final String ENTREZ_GENE = "NCBI Entrez Gene";

    public NCBIGeneProvider() {
        super(GENE);
    }

    public static class GeneSummary {
        public String id;
        public String url;
        public Item name;
        public Item desc;
        public Item orgname; 
        public String label;
        public Item otherAliases;
        public GeneSummary(DocSummary sum) {
            this.id = sum.id;
            this.url = GENE_URL + id;
            this.name = sum.items.get(NAME).get(0);
            this.desc = sum.items.get(DESC).get(0);
            this.orgname = sum.items.get(ORGNAME).get(0);
            this.otherAliases= sum.items.get(OTHER_ALIASES).get(0);
            //this.label = name.value+ " (" + orgname.value + ")";
            StringBuilder label = new StringBuilder();
            label.append(name.value);
            label.append(" (");
            label.append(this.id);
            if (this.otherAliases.value != null && !this.otherAliases.value.isEmpty()) {
                label.append(" ");
                label.append(this.otherAliases.value);
            }
            label.append(")");
            this.label = label.toString();
        }
    }
}
