/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESearch;
import org.eaglei.search.provider.ncbi.EUtils;

public final class EFetch
extends EUtils {
    private static final Log logger = LogFactory.getLog(EFetch.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final String EUTILS_FETCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?";

    public static ESearch.ESearchResult fetch(ESearch.ESearchResult result, String db, String tool, int max) throws IOException {
        if (!result.ids.isEmpty()) {
            String fetchURL = EFetch.buildServiceURL(EUTILS_FETCH_URL, result.ids, db, max, tool);
            if (DEBUG) {
                logger.debug((Object)("Querying NCBI eFetchat " + fetchURL));
            }
            result.details = EUtils.executeNCBIRequest(fetchURL);
            if (DEBUG) {
                logger.debug((Object)("Received details: " + EUtils.serializeDocument(result.details)));
            }
        }
        return result;
    }
}

