package org.eaglei.search.provider.ncbi.mesh;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.ESummary.Item;
import org.eaglei.search.provider.ncbi.ESummary.ListItem;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;

/**
 * Contains logic for querying NCBI MeSH via EUtils.
 * 
 * Cannot contain references to eagle-i code.
 *
 * @author rfrost
 */
public class NCBIMeSHProvider extends NCBIDBProvider {

    private static final Log logger = LogFactory.getLog(NCBIMeSHProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
        
    public static final String MESH_URL = "http://www.ncbi.nlm.nih.gov/mesh/";
    public static final String MESH= "mesh";
    public static final String NCBI_MESH_NAME = "NCBI MeSH";
    public static final String MESH_TERMS= "DS_MeshTerms";
    public static final String STRING = "string";
    public static final String SCOPE_NOTE = "DS_ScopeNote";    
    public static final String IDXLINKS = "DS_IdxLinks";
    public static final String LINKSTYPE= "LinksType";
    public static final String TREENUM= "TreeNum";    
    
    public NCBIMeSHProvider() {
        super(MESH);
    }
    
    public static class MeSHSummary {
        public String id;
        public String url;
        public Item scopeNote;
        public ListItem meshTerms;
        public Item meshTerm;
        public String label;
        public MeSHSummary(final ESummaryResult sum) {
            this.id = sum.id;
            this.url = MESH_URL + id;
            this.scopeNote = sum.items.get(SCOPE_NOTE).get(0);
            this.meshTerms = (ListItem) sum.items.get(MESH_TERMS).get(0);
            this.meshTerm = meshTerms.items.get(STRING).get(0);
            this.label = meshTerm.value;
        }
    }
}
