package org.eaglei.search.provider.ncbi.pubmed;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.ESummary.Item;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;

/**
 * Contains logic for querying PubMed via NCBI EUtils.
 *
 * @author rfrost
 */
public final class NCBIPubMedProvider extends NCBIDBProvider {

    private static final Log logger = LogFactory.getLog(NCBIPubMedProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    
    public static final String PUBMED_URL = "http://www.ncbi.nlm.nih.gov/pubmed/";
    public static final String PUBMED = "pubmed";
    public static final String NCBI_PUBMED_NAME = "NCBI PubMed";
    
    // eSummary Items
    public static final String TITLE = "Title";
    public static final String AUTHOR_LIST = "AuthorList";
    public static final String AUTHOR = "Author";
    public static final String SOURCE = "Source";
    public static final String FULL_JOURNAL_NAME= "FullJournalName";
    public static final String SO= "SO";

    public NCBIPubMedProvider() {
        super(PUBMED);
    }    

    public static class PubMedSummary {
        public String pmid;
        public String url;
        public Item journal;
        public Item so;
        public Item title;
        public String descrip;
        public final String label;
        public PubMedSummary(ESummaryResult sum) {
            this.pmid = sum.id;
            this.url = PUBMED_URL + pmid;
            this.journal = sum.items.get(FULL_JOURNAL_NAME).get(0);
            this.so = sum.items.get(SO).get(0);
            this.title = sum.items.get(TITLE).get(0);
            StringBuffer sb= new StringBuffer();
            sb.append(journal.value);
            sb.append(". ");
            sb.append(so.value);
            this.descrip = sb.toString();
            this.label = title.value;
        }
    }
}
