/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESearch;
import org.eaglei.search.provider.ncbi.EUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ESummary
extends EUtils {
    private static final Log logger = LogFactory.getLog(ESummary.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String EUTILS_SUMMARY_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?";

    public static void getSummaries(ESearch.ESearchResult result, String db, String tool, int max) throws IOException {
        if (!result.ids.isEmpty()) {
            String summaryURL = ESummary.buildServiceURL(EUTILS_SUMMARY_URL, result.ids, db, max, tool);
            if (DEBUG) {
                logger.debug((Object)("Querying NCBI eSummary at " + summaryURL));
            }
            result.details = EUtils.executeNCBIRequest(summaryURL);
            if (DEBUG) {
                // empty if block
            }
        }
    }

    public static List<ESummaryResult> parseESummaryResult(Document doc) throws IOException {
        Element eSummaryResult = doc.getDocumentElement();
        NodeList children = eSummaryResult.getChildNodes();
        ArrayList<ESummaryResult> docs = new ArrayList<ESummaryResult>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("DocSum")) continue;
            ESummaryResult docSum = new ESummaryResult(node);
            docs.add(docSum);
        }
        return docs;
    }

    public static class ListItem
    extends Item {
        public Map<String, List<Item>> items = new HashMap<String, List<Item>>();
    }

    public static class Item {
        public String name;
        public String type;
        public String value;
    }

    public static class ESummaryResult {
        public String id;
        public Map<String, List<Item>> items = new HashMap<String, List<Item>>();

        public ESummaryResult(Node node) throws IOException {
            NodeList idNodes = node.getChildNodes();
            for (int j = 0; j < idNodes.getLength(); ++j) {
                Node child = idNodes.item(j);
                if (child.getNodeName().equals("Id")) {
                    this.id = child.getTextContent();
                    continue;
                }
                if (!child.getNodeName().equals("Item")) continue;
                Item item = this.parseItem(child);
                if (!this.items.containsKey(item.name)) {
                    this.items.put(item.name, new ArrayList());
                }
                this.items.get(item.name).add(item);
            }
        }

        private Item parseItem(Node itemNode) throws IOException {
            String type = itemNode.getAttributes().getNamedItem("Type").getNodeValue();
            Item item = null;
            if (type.equals("List") || type.equals("Structure")) {
                item = new ListItem();
                NodeList idNodes = itemNode.getChildNodes();
                for (int j = 0; j < idNodes.getLength(); ++j) {
                    Node child = idNodes.item(j);
                    if (!child.getNodeName().equals("Item")) continue;
                    Item childItem = this.parseItem(child);
                    if (!item.items.containsKey(childItem.name)) {
                        item.items.put(childItem.name, new ArrayList());
                    }
                    item.items.get(childItem.name).add(childItem);
                }
            } else {
                item = new Item();
                item.value = itemNode.getTextContent();
            }
            item.name = itemNode.getAttributes().getNamedItem("Name").getNodeValue();
            return item;
        }
    }
}

