/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.mesh;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;

public class NCBIMeSHProvider
extends NCBIDBProvider {
    private static final Log logger = LogFactory.getLog(NCBIMeSHProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String MESH_URL = "http://www.ncbi.nlm.nih.gov/mesh/";
    public static final String MESH = "mesh";
    public static final String NCBI_MESH_NAME = "NCBI MeSH";
    public static final String MESH_TERMS = "DS_MeshTerms";
    public static final String STRING = "string";
    public static final String SCOPE_NOTE = "DS_ScopeNote";
    public static final String IDXLINKS = "DS_IdxLinks";
    public static final String LINKSTYPE = "LinksType";
    public static final String TREENUM = "TreeNum";

    public NCBIMeSHProvider() {
        super(MESH);
    }

    public static class MeSHSummary {
        public String id;
        public String url;
        public ESummary.Item scopeNote;
        public ESummary.ListItem meshTerms;
        public ESummary.Item meshTerm;
        public String label;

        public MeSHSummary(ESummary.ESummaryResult sum) {
            this.id = sum.id;
            this.url = NCBIMeSHProvider.MESH_URL + this.id;
            this.scopeNote = sum.items.get(NCBIMeSHProvider.SCOPE_NOTE).get(0);
            this.meshTerms = (ESummary.ListItem)sum.items.get(NCBIMeSHProvider.MESH_TERMS).get(0);
            this.meshTerm = this.meshTerms.items.get(NCBIMeSHProvider.STRING).get(0);
            this.label = this.meshTerm.value;
        }
    }
}

