/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.nif;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.nif.NIFQueryUtil;
import org.eaglei.services.InstitutionRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NIFSearchProvider
implements SearchProvider {
    protected static final Log logger = LogFactory.getLog(NIFSearchProvider.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    protected final EIOntModel eagleiOntModel;
    protected final InstitutionRegistry institutionRegistry;
    private final EIEntity MOUSE;
    private final EIURI REPOSITORY_URI = EIURI.create((String)"repository");
    private static final EIURI uri = EIURI.create((String)"foo");

    public NIFSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        assert (eagleiOntModel != null);
        assert (registry != null);
        this.eagleiOntModel = eagleiOntModel;
        this.institutionRegistry = registry;
        this.MOUSE = eagleiOntModel.getClass(EIURI.create((String)"http://purl.org/obo/owl/NCBITaxon#NCBITaxon_10090")).getEntity();
    }

    public void init() throws IOException {
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        SearchResultSet resultSet = new SearchResultSet(request);
        resultSet.setStartIndex(request.getStartIndex());
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            return resultSet;
        }
        String query = request.getTerm().getQuery();
        Document doc = NIFQueryUtil.search(query, null, null, request.getStartIndex(), request.getMaxResults());
        Element rootElement = doc.getDocumentElement();
        try {
            int totalCount = Integer.parseInt(rootElement.getAttribute("resultCount"));
            resultSet.setTotalCount(totalCount);
            Node resultsNode = rootElement.getChildNodes().item(0);
            NodeList resultNodeList = resultsNode.getChildNodes();
            for (int i = 0; i < resultNodeList.getLength(); ++i) {
                String repository = null;
                String url = null;
                String description = null;
                Node resultNode = resultNodeList.item(i);
                NodeList propertyNodeList = resultNode.getChildNodes();
                for (int j = 0; j < propertyNodeList.getLength(); ++j) {
                    Node propertyNode = propertyNodeList.item(j);
                    String propertyName = propertyNode.getFirstChild().getTextContent();
                    if (propertyName.equals("SITE")) {
                        repository = propertyNode.getLastChild().getTextContent();
                        continue;
                    }
                    if (propertyName.equals("STRAIN4")) {
                        url = propertyNode.getLastChild().getTextContent();
                        continue;
                    }
                    if (!propertyName.equals("TYPE")) continue;
                    description = propertyNode.getLastChild().getTextContent();
                }
                if (repository == null || url == null || description == null) {
                    logger.error((Object)(request.toString() + ":   NIF mouse result missing expected property. SITE: " + repository + " STRAIN4: " + url + " TYPE: " + description));
                    continue;
                }
                EIEntity entity = EIEntity.create(url, description);
                SearchResult result = new SearchResult(entity, this.MOUSE, null, null);
                result.addDataTypeProperty(this.REPOSITORY_URI, repository);
                result.setURL(url);
                if (!"unclassified".equals(description)) {
                    result.setHighlight(description);
                }
                resultSet.getResults().add(result);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error reading NIF search result.  Request: " + request.toString()), (Throwable)e);
            throw new IOException("Error get search result", e);
        }
        return resultSet;
    }

    public SearchCounts count(SearchCountRequest countRequest) throws IOException {
        SearchRequest request = countRequest.getRequest();
        SearchCounts counts = new SearchCounts(request);
        return counts;
    }

    private String getQuery(SearchRequest request) throws IOException {
        return this.getQuery(request, false, Collections.EMPTY_SET, false);
    }

    protected static EIURI getType(SearchRequest request) {
        SearchRequest.TypeBinding binding = request.getBinding();
        if (binding != null) {
            return binding.getType();
        }
        SearchRequest.Term term = request.getTerm();
        if (term != null && term.getURI() != null) {
            return term.getURI();
        }
        return null;
    }

    protected boolean isType(EIURI type, EIURI target) {
        if (type == null || target == null) {
            return false;
        }
        if (type.equals((Object)target)) {
            return true;
        }
        EIClass eiClass = this.eagleiOntModel.getClass(target);
        if (eiClass != null && eiClass.hasSubClass()) {
            for (EIClass sub : this.eagleiOntModel.getSubClasses(target)) {
                if (!this.isType(type, sub.getEntity().getURI())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getQuery(SearchRequest request, boolean includeType, Set<EIURI> typesToIgnore, boolean includeInstitution) {
        EIURI uri;
        SearchRequest.TypeBinding binding;
        StringBuilder sb = new StringBuilder();
        SearchRequest.Term term = request.getTerm();
        if (term != null) {
            if (term.getQuery() != null) {
                sb.append(term.getQuery() + " ");
            }
            if (term.getURI() != null) {
                for (String label : this.eagleiOntModel.getLabels(term.getURI())) {
                    sb.append(label + " ");
                }
            }
        }
        if ((binding = request.getBinding()) != null && includeType && !typesToIgnore.contains(uri = binding.getType())) {
            for (String label : this.eagleiOntModel.getLabels(uri)) {
                sb.append(label + " ");
            }
        }
        if (request.getInstitution() != null && includeInstitution) {
            EIEntity entity = this.institutionRegistry.getInstitution(request.getInstitution());
            sb.append(entity.getLabel());
        }
        if (DEBUG) {
            logger.debug((Object)("Using NIF query: " + sb.toString()));
        }
        return sb.toString();
    }
}

