package org.eaglei.search.provider.rdf;

/**
 * Configuration for connecting to the repository.
 */
public final class RepositoryConfig {
    
    public static final String PUBLISHED_NG = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    public static final String DEFAULT_NG = "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace";
    
    private String url;    
    private String username = null;    
    private String password = null;
    // URI of default graph for query; optional
    private String defaultGraphURI = PUBLISHED_NG;
    private String view = "published-resources";
    
    public void setUrl(String url) {
        this.url = url;
    }
    public String getUrl() {
        return url;
    }
    public void setUsername(String username) {
        this.username = username;
    }
    public String getUsername() {
        return username;
    }
    public void setPassword(String password) {
        this.password = password;
    }
    public String getPassword() {
        return password;
    }
    
    public String getView() {
        return this.view;
    }
    
    public void setView(final String view) {
        this.view = view;
    }
    
    /**
     * Sets the URI of the default graph that is the target for the queries.
     * @param defaultGraphURI URI of default graph
     */
    public void setDefaultGraphURI(final String defaultGraphURI) {
        this.defaultGraphURI = defaultGraphURI;
    }
    
    /**
     * Sets the URI of the default graph that is the target for the queries.
     * @return URI of default graph.
     */
    public String getDefaultGraphURI() {
        return this.defaultGraphURI;
    }    
}
