/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.rdf.AbstractRDFProvider;
import org.eaglei.search.provider.rdf.RDFGenerator;

public class RDFModelProvider
extends AbstractRDFProvider {
    private static final Log logger = LogFactory.getLog(RDFModelProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private Model model;

    public RDFModelProvider(EIOntModel eagleiOntModel, DataGenParams genParams, EIEntity institution) throws IOException {
        super(eagleiOntModel, institution, null);
        assert (genParams != null);
        RDFGenerator generator = new RDFGenerator(eagleiOntModel);
        generator.generate(genParams);
        this.setModel(generator.getModel());
    }

    public RDFModelProvider(Model model, EIOntModel eagleiOntModel, EIEntity institution) throws IOException {
        super(eagleiOntModel, institution, null);
        this.setModel(model);
    }

    private void setModel(Model model) {
        assert (model != null);
        this.model = model;
    }

    @Override
    protected QueryExecution getQueryExecution(Query query) {
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.model);
        return qe;
    }
}

