package org.eaglei.search.provider.rdf;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SearchRDFConfig {

    private @Autowired EIOntModel eagleiOntModel;
    private @Autowired InstitutionRegistry institutionRegsitry;
    private @Autowired RepositoryConfig sparqlConfig;
    private @Autowired RepositoryConfig harvestConfig;    
    
    // lazy for central search node case
    @Bean @Lazy
    public SPARQLProtocolProvider sparqlSearchProvider() {
        EIEntity institution = institutionRegsitry.getInstitution();
        return new SPARQLProtocolProvider(eagleiOntModel, institution, sparqlConfig);
    }
    
    @Bean @Lazy
    public RepositoryHarvester harvester() {
        EIEntity institution = institutionRegsitry.getInstitution();
        return new RepositoryHarvester(eagleiOntModel, institution, harvestConfig);
    }
    
}
