package org.eaglei.search.provider.rdf;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SearchRDFConfig {

    private @Autowired EIOntModel eagleiOntModel;
    private @Autowired InstitutionRegistry institutionRegsitry;
    
    // lazy for central search node case
    @Bean @Lazy
    public SPARQLProtocolProvider sparqlSearchProvider() {
        EIEntity institution = institutionRegsitry.getInstitution();
        return new SPARQLProtocolProvider(eagleiOntModel, institution, repositoryClient());
    }
    
    @Bean @Lazy
    public RepositoryHarvester harvester() {
        EIEntity institution = institutionRegsitry.getInstitution();
        return new RepositoryHarvester(eagleiOntModel, institution, repositoryClient());
    }
    
    @Bean @Lazy
    public RepositoryHttpClient repositoryClient() {
        if (institutionRegsitry.getInstitution() != null) {
            return new RepositoryHttpClient(institutionRegsitry.getSubdomain());
        } else {
            return null;
        }
    }
    
}
