package org.eaglei.search.provider.rdf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.services.repository.RepositoryHttpConfig.RepositoryLocale;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;

/**
 * AbstractRDFProvider subclass that executes the SPARQL query 
 * against a SPARQL endpoint.
 */
public class SPARQLProtocolProvider extends AbstractRDFProvider {
     
    private static final Log logger = LogFactory.getLog(SPARQLProtocolProvider.class);
    
    private RepositoryHttpConfig repoConfig;

    /**
     * Creates a SearchProvider for an RDF-repository that is accessed via SPARQL Protocol at the 
     * specified URL.
     * 
     */
    public SPARQLProtocolProvider(final EIOntModel eagleiOntModel, final EIEntity institution,
            final RepositoryHttpConfig repoConfig) {
        super(eagleiOntModel, institution);
        this.repoConfig = repoConfig;
    }
    
    @Override
    protected SearchResult createSearchResultFromModel(final String uri, final Model model) {    
        SearchResult result = super.createSearchResultFromModel(uri, model);
    	if (result != null) {
    	    // set URL to URI for result entity
    	    result.setURL(result.getEntity().toString());
    	}
    	return result;
    }
    
    @Override
    protected QueryExecution getQueryExecution(final Query query) {
        // cast to QueryEngineHTTP to allow us to set the basic http auth credentials and default graph URI
        final QueryEngineHTTP qe = (QueryEngineHTTP) QueryExecutionFactory.sparqlService(repoConfig.getFullRepositoryUrl(RepositoryLocale.SPARQL_URL), query);
        if (repoConfig.getSearchUsername() != null && repoConfig.getSearchPassword() != null) {
        	qe.setBasicAuthentication(repoConfig.getSearchUsername(), repoConfig.getSearchPassword().toCharArray());
        	qe.addDefaultGraph(RepositoryHttpConfig.PUBLISHED_NG);
        }
        
        return qe;
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }
}
