/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.rdf.RDFGenerator;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class RDFFileGenerator {
    private static final Log logger = LogFactory.getLog(RDFFileGenerator.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].length() == 0) {
            logger.error((Object)"RDFFileGenerator <output RDF path>");
            return;
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"search-rdf-config.xml"});
        InstitutionRegistry institutionRegistry = (InstitutionRegistry)context.getBean(InstitutionRegistry.class);
        EIOntModel eagleiOntModel = (EIOntModel)context.getBean(EIOntModel.class);
        RDFFileGenerator.generate(args[0], institutionRegistry, eagleiOntModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String outputPath, InstitutionRegistry institutionRegistry, EIOntModel eagleiOntModel) throws IOException {
        assert (outputPath != null);
        File outputDir = new File(outputPath);
        logger.debug((Object)("Generating test RDF data to directory: " + outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            return;
        }
        List institutions = institutionRegistry.getInstitutions();
        for (EIEntity institution : institutions) {
            String uri = institution.getURI().toString();
            String label = institution.getLabel();
            DataGenParams genParams = DataGenParams.createForOneInstitution((String)uri, (String)label);
            RDFGenerator generator = new RDFGenerator(eagleiOntModel);
            logger.debug((Object)("Generating for institution: " + label));
            generator.generate(genParams);
            Model rdf = generator.getModel();
            logger.debug((Object)("Generated " + rdf.listStatements().toList().size() + " triples for " + label));
            File rdfFile = new File(outputDir, label + ".rdf");
            logger.debug((Object)("Serializing RDF to " + rdfFile.getAbsolutePath() + "..."));
            FileWriter writer = new FileWriter(rdfFile);
            try {
                rdf.write((Writer)writer, "RDF/XML");
                ((Writer)writer).flush();
            }
            finally {
                ((Writer)writer).close();
            }
            logger.debug((Object)("...finished writing RDF to " + rdfFile.getAbsolutePath()));
        }
    }
}

