/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.spin.tools.Util;

public enum Query {
    RDF,
    Count;

    public static final String Prefix = "Spin.Eagle-I.";
    public final String queryType = this.makeQueryType();
    public static final List<String> queryTypes;

    private String makeQueryType() {
        return Prefix + this.name();
    }

    private static List<String> makeQueryTypeList() {
        ArrayList result = Util.makeArrayList();
        for (Query query : Query.values()) {
            result.add(query.queryType);
        }
        return Collections.unmodifiableList(result);
    }

    public static Query fromQueryType(String queryType) {
        for (Query query : Query.values()) {
            if (!query.queryType.equals(queryType)) continue;
            return query;
        }
        throw new IllegalArgumentException("Unknown query type '" + queryType + "', allowed values are " + Arrays.asList(Query.values()));
    }

    static {
        queryTypes = Query.makeQueryTypeList();
    }
}

