/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.driver;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.tools.Util;

public final class ResultSerializer<T> {
    private static final Logger log = Logger.getLogger(ResultSerializer.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final ResultSerializer<SearchResultSet> SearchResultSet = new ResultSerializer(Serializer.SearchResultSetSerializer);
    public static final ResultSerializer<SearchCounts> SearchCounts = new ResultSerializer(Serializer.SearchCountsSerializer);
    private final Serializer<T> serializer;

    private ResultSerializer(Serializer<T> serializer) {
        Util.guardNotNull(serializer);
        this.serializer = serializer;
    }

    public Collection<T> deserialize(Collection<String> results) {
        Util.guardNotNull(results);
        ArrayList unmarshalled = Util.makeArrayList((int)results.size());
        for (String json : results) {
            if (json != null) {
                try {
                    Object resultSet = this.serializer.deserialize(json);
                    unmarshalled.add(resultSet);
                }
                catch (SerializationException e) {
                    log.error((Object)"Error deserializing result, proceeding with others: ", (Throwable)e);
                    if (!DEBUG) continue;
                    log.debug((Object)("Raw results that couldn't be deserialized: '" + json + "'"));
                }
                continue;
            }
            log.warn((Object)"Result is null, skipping deserialization and proceeding with others");
            unmarshalled.add(null);
        }
        if (INFO) {
            log.info((Object)("Got results from " + unmarshalled.size() + " repositories"));
        }
        return unmarshalled;
    }
}

