/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.driver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eaglei.network.driver.Query;
import org.eaglei.network.driver.QueryWrapUpStrategy;
import org.eaglei.network.driver.ResultSerializer;
import org.eaglei.network.driver.SSLUtilities;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.node.NodeException;
import org.spin.node.acknack.AckNack;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.Querier;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.identity.local.LocalAuthEntry;
import org.spin.query.message.identity.local.LocalIdentityService;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.signature.Identity;

public final class SpinMultiNodeSearchProvider
implements MultiNodeSearchProvider {
    private static final Logger log = Logger.getLogger(SpinMultiNodeSearchProvider.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    static final Float DefaultPollingFrequency = Float.valueOf(5.0f);
    static final String DefaultPeerGroup = "EAGLE-I-TEST";
    static final Querier.Credentials DefaultCredentials = new Querier.Credentials("eagle-i.org", "eagle-i-search-app", "eagle-i-search-app");
    private final Querier querier;

    public SpinMultiNodeSearchProvider() throws IOException {
        this(System.getProperty(Props.ProviderSpinNetworkUrlPropertyName.propKey));
    }

    public SpinMultiNodeSearchProvider(String entryPointNodeURL) throws IOException {
        this(SpinMultiNodeSearchProvider.makeAgentConfig(SpinMultiNodeSearchProvider.guardEntryPointURLIsNotNull(entryPointNodeURL)), null);
    }

    SpinMultiNodeSearchProvider(AgentConfig agentConfig, NodeConnector nodeConnector) throws IOException {
        if (DEBUG) {
            log.debug((Object)"Creating SPIN Network Querier");
        }
        Util.guardNotNull((Object)agentConfig);
        SpinMultiNodeSearchProvider.enableSSLWorkarounds();
        try {
            this.querier = SpinMultiNodeSearchProvider.makeQuerier(agentConfig, nodeConnector);
        }
        catch (Exception e) {
            throw new IOException("Error creating Querier: ", e);
        }
        if (INFO) {
            log.info((Object)("Created " + SpinMultiNodeSearchProvider.class.getSimpleName() + " for peer group '" + agentConfig.getPeerGroupToQuery() + "', using entry point '" + agentConfig.getNodeConnectorEndpoint() + "'"));
        }
    }

    private static Querier makeQuerier(AgentConfig agentConfig, NodeConnector nodeConnector) throws ConfigException, NodeException {
        if (nodeConnector == null) {
            return new Querier(agentConfig, Holder.identityService);
        }
        return new Querier(agentConfig, Holder.identityService, nodeConnector);
    }

    private static void enableSSLWorkarounds() {
        SSLUtilities.trustAllHttpsCertificates();
        SSLUtilities.trustAllHostnames();
    }

    private static String guardEntryPointURLIsNotNull(String entryPointNodeURL) throws IOException {
        if (entryPointNodeURL == null) {
            throw new IOException("SPIN URL property " + Props.ProviderSpinNetworkUrlPropertyName.propKey + " not set");
        }
        return entryPointNodeURL;
    }

    String getEntryPointURL() {
        return this.querier.getAgent().getAgentConfig().getNodeConnectorEndpoint().getAddress();
    }

    public synchronized void init() throws IOException {
    }

    public Collection<SearchCounts> count(SearchCountRequest countRequest) throws IOException {
        return this.sendQuery(Query.Count, countRequest, Serializer.SearchCountRequestSerializer, ResultSerializer.SearchCounts, QueryWrapUpStrategy.passThrough());
    }

    public Collection<SearchResultSet> query(SearchRequest searchRequest) throws IOException {
        return this.sendQuery(Query.RDF, searchRequest, Serializer.SearchRequestSerializer, ResultSerializer.SearchResultSet, QueryWrapUpStrategy.SearchResultSet);
    }

    private <C, R> Collection<R> sendQuery(Query query, C searchRequest, Serializer<C> requestSerializer, ResultSerializer<R> resultSerializer, QueryWrapUpStrategy<R> wrapUpStrategy) throws IOException {
        Util.guardNotNull((Object)((Object)query));
        Util.guardNotNull(searchRequest);
        Util.guardNotNull(requestSerializer);
        Util.guardNotNull(resultSerializer);
        Util.guardNotNull(wrapUpStrategy);
        if (DEBUG) {
            log.debug((Object)("making query with type: '" + query.queryType + "'"));
        }
        String serializedRequest = this.serialize(searchRequest, requestSerializer);
        AckNack ack = this.submitQuery(query.queryType, serializedRequest);
        Identity identity = this.certifyIdentity();
        AnnotatedResults results = this.receiveResults(ack, identity);
        if (DEBUG) {
            log.debug((Object)("Raw, unmarshalled results: " + results.rawResults));
        }
        return wrapUpStrategy.wrapUp(results.timeoutOccurred, SpinMultiNodeSearchProvider.unmarshalResults(results.rawResults, resultSerializer));
    }

    private AnnotatedResults receiveResults(AckNack ack, Identity identity) throws IOException {
        try {
            return new AnnotatedResults(this.querier.receive(ack, identity), false);
        }
        catch (TimeoutException e) {
            return new AnnotatedResults(this.getAvailableResultsForTimedOutQuery(ack, identity), true);
        }
        catch (AgentException e) {
            throw new IOException("Error receiving the query '" + ack.getQueryID() + "': ", e);
        }
    }

    private <T> String serialize(T object, Serializer<T> serializer) throws IOException {
        Util.guardNotNull(serializer);
        try {
            return serializer.serialize(object);
        }
        catch (SerializationException e) {
            throw new IOException("Error serializing SearchRequest: ", e);
        }
    }

    private Identity certifyIdentity() throws IOException {
        try {
            return this.querier.getIdentityService().certify(DefaultCredentials.getDomain(), DefaultCredentials.getUsername(), DefaultCredentials.getPassword());
        }
        catch (IdentityServiceException e) {
            throw new IOException("Error sending query: couldn't certify credentials: " + DefaultCredentials, e);
        }
    }

    private Collection<String> getAvailableResultsForTimedOutQuery(AckNack ack, Identity identity) throws IOException {
        Util.guardNotNull((Object)ack);
        Util.guardNotNull((Object)identity);
        try {
            return this.querier.decryptResults(this.querier.getAgent().getResultNoDelete(ack.getQueryID(), identity));
        }
        catch (Exception e) {
            throw new IOException("Error getting results of timed-out query '" + ack.getQueryID() + "'", e);
        }
    }

    private AckNack submitQuery(String queryType, String serializedSearchRequest) throws IOException {
        try {
            return this.querier.queryAsync(queryType, DefaultCredentials, serializedSearchRequest);
        }
        catch (AgentException e) {
            throw new IOException("Error submitting the Query: (queryType: '" + queryType + "')", e);
        }
    }

    private static <T> Collection<T> unmarshalResults(Collection<String> results, ResultSerializer<T> serializer) {
        Util.guardNotNull(results);
        Util.guardNotNull(serializer);
        return serializer.deserialize(results);
    }

    private static IdentityService makeIdentityService() {
        LocalAuthEntry defaultAuthEntry = new LocalAuthEntry(DefaultCredentials.getDomain(), DefaultCredentials.getUsername(), DefaultCredentials.getPassword(), "user");
        return new LocalIdentityService(Arrays.asList(defaultAuthEntry));
    }

    private static AgentConfig makeAgentConfig(String entryPointNodeURL) {
        Util.guardNotNull((Object)entryPointNodeURL);
        try {
            return ConfigTool.loadAgentConfig();
        }
        catch (ConfigException e) {
            if (INFO) {
                log.info((Object)"Couldn't load agent.xml from the filesystem or classpath, using defaults.");
            }
            return SpinMultiNodeSearchProvider.makeDefaultAgentConfig(entryPointNodeURL);
        }
    }

    public static AgentConfig makeDefaultAgentConfig(String entryPointNodeURL) {
        AgentConfig config = new AgentConfig();
        config.setMaxWaitTime(60000L);
        config.setPollingFrequency(DefaultPollingFrequency);
        config.setPeerGroupToQuery(DefaultPeerGroup);
        config.setNodeConnectorEndpoint(new EndpointConfig(EndpointType.SOAP, entryPointNodeURL));
        return config;
    }

    static /* synthetic */ IdentityService access$100() {
        return SpinMultiNodeSearchProvider.makeIdentityService();
    }

    private static final class Holder {
        static final IdentityService identityService = SpinMultiNodeSearchProvider.access$100();

        private Holder() {
        }
    }

    private static final class AnnotatedResults {
        public final Collection<String> rawResults;
        public final boolean timeoutOccurred;

        private AnnotatedResults(Collection<String> rawResults, boolean timeoutOccurred) {
            this.rawResults = rawResults;
            this.timeoutOccurred = timeoutOccurred;
        }
    }

    static enum Props {
        ProviderSpinNetworkUrlPropertyName("org.eaglei.search.provider.spin.network.url"),
        ProviderSpinQueryTypePropertyName("search.provider.spin.query.type");

        public final String propKey;

        private Props(String propKey) {
            this.propKey = propKey;
        }
    }
}

