/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.driver;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.tools.Util;

public abstract class QueryWrapUpStrategy<R> {
    private static final QueryWrapUpStrategy<Object> PassThroughStrategy = new QueryWrapUpStrategy<Object>(){

        @Override
        Collection<Object> wrapUp(boolean timeoutOccurred, Collection<Object> results) {
            return results;
        }
    };
    public static final QueryWrapUpStrategy<SearchResultSet> SearchResultSet = new QueryWrapUpStrategy<SearchResultSet>(){

        @Override
        Collection<SearchResultSet> wrapUp(boolean timeoutOccurred, Collection<SearchResultSet> results) {
            return QueryWrapUpStrategy.setMetadataFields(timeoutOccurred, results);
        }
    };

    private QueryWrapUpStrategy() {
    }

    abstract Collection<R> wrapUp(boolean var1, Collection<R> var2);

    public static final <R> QueryWrapUpStrategy<R> passThrough() {
        return PassThroughStrategy;
    }

    private static Collection<SearchResultSet> setMetadataFields(boolean timeoutOccurred, Collection<SearchResultSet> resultSets) {
        if (timeoutOccurred) {
            for (SearchResultSet resultSet : resultSets) {
                resultSet.setWasTimeout(true);
                resultSet.setInstitutionsIncluded(QueryWrapUpStrategy.getInstitutionsPresentInResults(resultSet));
            }
        }
        return resultSets;
    }

    public static List<EIURI> getInstitutionsPresentInResults(SearchResultSet resultSet) {
        Util.guardNotNull((Object)resultSet);
        HashSet institutions = Util.makeHashSet();
        for (SearchResult result : resultSet.getResults()) {
            institutions.add(result.getInstitution().getURI());
        }
        return Util.makeArrayList((Collection)institutions);
    }
}

