/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.client.advanced;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.client.advanced.FilterPanel;
import org.eaglei.search.request.SearchRequest;

public class FilterPanel
extends Composite {
    private VerticalPanel panelFilters = new VerticalPanel();
    private StringFilter keywordFilter;
    private ListBoxFilter institutionFilter;
    private ClassFilter typeFilter;
    private Button searchButton;
    private List<EIEntity> listInstitutionEntities = null;
    private EIClass resource;

    public FilterPanel() {
        this.initWidget((Widget)this.panelFilters);
        this.keywordFilter = new StringFilter("Keyword");
        this.institutionFilter = new ListBoxFilter("Institution");
        this.institutionFilter.listBox.addItem("All Institutions");
        ClientModelManager.INSTANCE.getInstitutions((ClientModelManager.InstitutionsCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.typeFilter = new ClassFilter("Type");
        this.searchButton = new Button("Search");
        this.searchButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setResource(EIClass resource) {
        this.resource = resource;
        this.typeFilter.setResource(resource, true);
        this.populatePropertyList();
    }

    private void populatePropertyList() {
        this.panelFilters.clear();
        if (this.resource.getProperties() != null) {
            this.populatePropertyList(this.resource.getProperties());
        } else {
            ClientModelManager.INSTANCE.getProperties(this.resource, (ClientModelManager.PropertyCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void populatePropertyList(List<EIProperty> properties) {
        this.panelFilters.add((Widget)this.keywordFilter);
        this.panelFilters.add((Widget)this.institutionFilter);
        this.panelFilters.add((Widget)this.typeFilter);
        for (EIProperty p : properties) {
            if (!(p instanceof EIObjectProperty)) continue;
            ClassFilter propFilter = new ClassFilter(p.getEntity().getLabel());
            this.panelFilters.add((Widget)propFilter);
            propFilter.setResource(((EIObjectProperty)p).getRange(), false);
        }
        this.panelFilters.add((Widget)this.searchButton);
    }

    private SearchRequest getSearchRequest() {
        SearchRequest request = new SearchRequest();
        String query = this.keywordFilter.textBox.getText();
        if (query != null) {
            query.trim();
        }
        if (query != null && query.length() > 0) {
            SearchRequest.Term term = new SearchRequest.Term(query);
            request.setTerm(term);
        }
        if (this.institutionFilter.listBox.getSelectedIndex() > 0) {
            EIURI institution = ((EIEntity)this.listInstitutionEntities.get(this.institutionFilter.listBox.getSelectedIndex() - 1)).getURI();
            request.setInstitution(institution);
        }
        EIURI selectedURI = this.typeFilter.classChooser.getSelectedURI();
        SearchRequest.TypeBinding binding = new SearchRequest.TypeBinding(selectedURI);
        request.setBinding(binding);
        return request;
    }

    static /* synthetic */ List access$002(FilterPanel x0, List x1) {
        x0.listInstitutionEntities = x1;
        return x0.listInstitutionEntities;
    }

    static /* synthetic */ ListBoxFilter access$100(FilterPanel x0) {
        return x0.institutionFilter;
    }

    static /* synthetic */ SearchRequest access$200(FilterPanel x0) {
        return x0.getSearchRequest();
    }

    static /* synthetic */ EIClass access$300(FilterPanel x0) {
        return x0.resource;
    }

    static /* synthetic */ void access$400(FilterPanel x0, List x1) {
        x0.populatePropertyList(x1);
    }
}

