/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.client.results;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.search.client.Application;
import org.eaglei.search.client.results.NavBar;
import org.eaglei.search.client.results.ResultsListPanel;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;

public class ResultsListPanel
extends Composite {
    static final int VISIBLE_RESULT_COUNT = 10;
    private VerticalPanel panelResults = new VerticalPanel();
    private SearchResultSet results;
    private NavBar navBar = new NavBar(this);

    public ResultsListPanel() {
        this.panelResults.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        this.panelResults.add((Widget)this.navBar);
        this.panelResults.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.initWidget((Widget)this.panelResults);
        this.setWidth("100%");
    }

    void setResultSet(SearchResultSet results) {
        if (this.results == results) {
            return;
        }
        this.results = results;
        int count = results.getTotalCount();
        int max = results.getStartIndex() + 10;
        if (max > count) {
            max = count;
        }
        this.navBar.update(results.getStartIndex(), count, max);
        for (int i = this.panelResults.getWidgetCount() - 1; i > 0; --i) {
            this.panelResults.remove(i);
        }
        for (SearchResult result : results.getResults()) {
            this.panelResults.add((Widget)new ResultPanel(this, result));
        }
    }

    void previousPage() {
        int startIndex = this.results.getStartIndex() - 10;
        assert (startIndex >= 0) : "paged beyond the start of the result list";
        this.executeNewSearch(startIndex);
    }

    void nextPage() {
        int startIndex = this.results.getStartIndex() + 10;
        assert (startIndex < this.results.getTotalCount()) : "paged beyond the end of the result list";
        this.executeNewSearch(startIndex);
    }

    private void executeNewSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest();
        SearchRequest oldRequest = this.results.getRequest();
        newRequest.setInstitution(oldRequest.getInstitution());
        newRequest.setTerm(oldRequest.getTerm());
        newRequest.setBinding(oldRequest.getBinding());
        newRequest.setStartIndex(startIndex);
        Application.executeSearch((SearchRequest)newRequest);
    }
}

