/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.client.results;

import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.eaglei.search.client.ApplicationImages;
import org.eaglei.search.client.results.ResultsListPanel;
import org.eaglei.search.client.results.ResultsTabPanel;
import org.eaglei.search.client.rpc.ClientSearchManager;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;

public class ResultsTabPanel
extends Composite
implements ClientSearchManager.SessionListener {
    public static int SUMMARY_DECK_INDEX;
    private static int STATUS_DECK_INDEX;
    private final VerticalPanel outer = new VerticalPanel();
    private final TabBar tabBar = new TabBar();
    private final List<Tab> listTabs = new ArrayList();
    private final DeckPanel deck = new DeckPanel();
    private final SimplePanel statusPanel = new SimplePanel();
    private final HorizontalPanel searchingPanel = new HorizontalPanel();
    private ResultsListPanel panelSummary;
    private SearchRequest request;
    private SearchResultSet results;

    public ResultsTabPanel() {
        this.initWidget((Widget)this.outer);
        this.outer.add((Widget)this.tabBar);
        this.tabBar.setStyleName("ResultsTabBar");
        this.tabBar.setVisible(false);
        this.outer.add((Widget)this.deck);
        this.deck.setWidth("100%");
        this.deck.setHeight("100%");
        SimplePanel panelWrapper = new SimplePanel();
        this.deck.add((Widget)panelWrapper);
        1 tab = new /* Unavailable Anonymous Inner Class!! */;
        SUMMARY_DECK_INDEX = this.tabBar.getTabCount();
        this.tabBar.addTab((Widget)tab);
        this.listTabs.add(tab);
        this.statusPanel.setStyleName("ResultsLoadingPanel");
        this.deck.add((Widget)this.statusPanel);
        STATUS_DECK_INDEX = this.tabBar.getTabCount();
        this.tabBar.addBeforeSelectionHandler((BeforeSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.tabBar.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        ClientSearchManager.INSTANCE.addSessionListener((ClientSearchManager.SessionListener)this);
        this.selectTab(SUMMARY_DECK_INDEX);
    }

    public void selectTab(int index) {
        this.tabBar.selectTab(index);
    }

    public void setLoggedOut() {
        this.statusPanel.setWidget((Widget)new Label("You must be signed in to see search results."));
        this.deck.showWidget(STATUS_DECK_INDEX);
    }

    public void setNoResults() {
        this.statusPanel.setWidget((Widget)new Label("No resources found."));
        this.deck.showWidget(STATUS_DECK_INDEX);
    }

    private void setSearching() {
        if (this.searchingPanel.getWidgetCount() == 0) {
            this.searchingPanel.add((Widget)ApplicationImages.LOADING);
            this.searchingPanel.add((Widget)new Label("Searching..."));
        }
        this.statusPanel.setWidget((Widget)this.searchingPanel);
        this.deck.showWidget(STATUS_DECK_INDEX);
    }

    public void setSearchRequest(SearchRequest request) {
        this.request = request;
        this.setSearching();
        ClientSearchManager.INSTANCE.getResults(request, (ClientSearchManager.ResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setResults(SearchResultSet results) {
        this.results = results;
        if (results == null || results.getTotalCount() == 0) {
            this.setNoResults();
        } else if (this.tabBar.getSelectedTab() == SUMMARY_DECK_INDEX) {
            this.displaySummary();
        }
    }

    private void displaySummary() {
        this.deck.showWidget(STATUS_DECK_INDEX);
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void displayTable() {
    }

    private void displayMap() {
    }

    public void onLogIn(String username) {
        this.setSearchRequest(this.request);
    }

    public void onLogOut() {
        this.setSearchRequest(this.request);
    }

    static /* synthetic */ void access$100(ResultsTabPanel x0) {
        x0.displaySummary();
    }

    static /* synthetic */ TabBar access$200(ResultsTabPanel x0) {
        return x0.tabBar;
    }

    static /* synthetic */ List access$300(ResultsTabPanel x0) {
        return x0.listTabs;
    }

    static /* synthetic */ void access$400(ResultsTabPanel x0, SearchResultSet x1) {
        x0.setResults(x1);
    }

    static /* synthetic */ ResultsListPanel access$500(ResultsTabPanel x0) {
        return x0.panelSummary;
    }

    static /* synthetic */ ResultsListPanel access$502(ResultsTabPanel x0, ResultsListPanel x1) {
        x0.panelSummary = x1;
        return x0.panelSummary;
    }

    static /* synthetic */ DeckPanel access$600(ResultsTabPanel x0) {
        return x0.deck;
    }

    static /* synthetic */ SearchResultSet access$700(ResultsTabPanel x0) {
        return x0.results;
    }
}

