/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.client.searchbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.client.searchbar.SearchBar;
import org.eaglei.search.client.searchbar.TermSuggestBox;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox;

public class SearchBar
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    ListBox institutionListBox;
    @UiField
    ListBox resourceListBox;
    @UiField
    TermSuggestBox termBox;
    @UiField
    Button searchButton;
    @UiField
    Anchor advancedLink;
    private List<EIClass> listTopLevelResourceClasses = null;
    private List<EIEntity> listInstitutionEntities = null;
    private SearchRequest currentRequest = null;
    private List<EIClass> listCurrentResourceClasses = null;

    public SearchBar() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.institutionListBox.addItem("All Institutions");
        ClientModelManager.INSTANCE.getInstitutions((ClientModelManager.InstitutionsCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.resourceListBox.addItem("All Resources");
        ClientModelManager.INSTANCE.getTopLevelClasses((ClientModelManager.TopLevelClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.searchButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.advancedLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.termBox.addSearchHandler((AbstractSearchBox.SearchHandler)new /* Unavailable Anonymous Inner Class!! */, true, true);
        this.termBox.setDefaultText();
    }

    public void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            this.termBox.setText(request.getTerm().getQuery());
        } else {
            this.termBox.setDefaultText();
        }
        this.setInstitution(request, this.currentRequest);
        this.setResource(request, this.currentRequest);
        this.currentRequest = request;
    }

    private void setInstitution(SearchRequest newRequest, SearchRequest oldRequest) {
        if (newRequest != null && newRequest.getInstitution() != null && this.listInstitutionEntities != null) {
            int i = 1;
            for (EIEntity inst : this.listInstitutionEntities) {
                if (inst.getURI().equals((Object)newRequest.getInstitution())) {
                    this.institutionListBox.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
        this.institutionListBox.setSelectedIndex(0);
    }

    private void setResource(SearchRequest newRequest, SearchRequest oldRequest) {
        if (this.listTopLevelResourceClasses == null) {
            return;
        }
        if (newRequest == null || newRequest.getBinding() == null) {
            this.addTopLevelResourceList();
            this.resourceListBox.setSelectedIndex(0);
        } else {
            EIURI uriTypeBinding = newRequest.getBinding().getType();
            int indexListBox = 1;
            for (EIClass top : this.listTopLevelResourceClasses) {
                if (top.getEntity().getURI().equals((Object)uriTypeBinding)) {
                    this.addTopLevelResourceList();
                    this.resourceListBox.setSelectedIndex(indexListBox);
                    return;
                }
                ++indexListBox;
            }
            ClientModelManager.INSTANCE.getSuperClasses(uriTypeBinding, (ClientModelManager.SuperClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void addTopLevelResourceList() {
        if (this.listCurrentResourceClasses != this.listTopLevelResourceClasses) {
            for (int i = this.resourceListBox.getItemCount() - 1; i > 0; --i) {
                this.resourceListBox.removeItem(i);
            }
            for (EIClass rclass : this.listTopLevelResourceClasses) {
                this.resourceListBox.addItem(rclass.getEntity().getLabel());
            }
            this.listCurrentResourceClasses = this.listTopLevelResourceClasses;
        }
    }

    private void addSuperClassResourceList(EIClass rClass) {
        for (int i = this.resourceListBox.getItemCount() - 1; i > 0; --i) {
            this.resourceListBox.removeItem(i);
        }
        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
        for (EIClass parent = rClass.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
            listAncestors.add(parent);
        }
        this.listCurrentResourceClasses = new ArrayList(listAncestors.size() + 1);
        for (int i = listAncestors.size() - 1; i >= 0; --i) {
            this.resourceListBox.addItem(((EIClass)listAncestors.get(i)).getEntity().getLabel());
            this.listCurrentResourceClasses.add(listAncestors.get(i));
        }
        this.resourceListBox.addItem(rClass.getEntity().getLabel());
        this.listCurrentResourceClasses.add(rClass);
    }

    private SearchRequest getSearchRequest() {
        String query = this.termBox.getText();
        if (query != null) {
            query.trim();
        }
        return this.getSearchRequest(query);
    }

    private SearchRequest getSearchRequest(String query) {
        SearchRequest request = new SearchRequest();
        if (query != null && query.length() > 0) {
            SearchRequest.Term term = new SearchRequest.Term(query);
            request.setTerm(term);
        }
        if (this.institutionListBox.getSelectedIndex() > 0) {
            EIURI institution = ((EIEntity)this.listInstitutionEntities.get(this.institutionListBox.getSelectedIndex() - 1)).getURI();
            request.setInstitution(institution);
        }
        if (this.resourceListBox.getSelectedIndex() > 0) {
            EIURI type = ((EIClass)this.listCurrentResourceClasses.get(this.resourceListBox.getSelectedIndex() - 1)).getEntity().getURI();
            SearchRequest.TypeBinding binding = new SearchRequest.TypeBinding(type);
            request.setBinding(binding);
        }
        return request;
    }

    static /* synthetic */ List access$002(SearchBar x0, List x1) {
        x0.listInstitutionEntities = x1;
        return x0.listInstitutionEntities;
    }

    static /* synthetic */ SearchRequest access$100(SearchBar x0) {
        return x0.currentRequest;
    }

    static /* synthetic */ void access$200(SearchBar x0, SearchRequest x1, SearchRequest x2) {
        x0.setInstitution(x1, x2);
    }

    static /* synthetic */ List access$302(SearchBar x0, List x1) {
        x0.listTopLevelResourceClasses = x1;
        return x0.listTopLevelResourceClasses;
    }

    static /* synthetic */ void access$400(SearchBar x0, SearchRequest x1, SearchRequest x2) {
        x0.setResource(x1, x2);
    }

    static /* synthetic */ SearchRequest access$500(SearchBar x0) {
        return x0.getSearchRequest();
    }

    static /* synthetic */ SearchRequest access$600(SearchBar x0, String x1) {
        return x0.getSearchRequest(x1);
    }

    static /* synthetic */ void access$700(SearchBar x0, EIClass x1) {
        x0.addSuperClassResourceList(x1);
    }
}

