/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractCustomDropdown
extends Composite
implements HasValueChangeHandlers<String>,
ClickHandler {
    private final PushButton button = new PushButton(new Image(GWT.getModuleBaseURL() + "drop_arrow.png"));
    private final Label box;
    private String allItemsLabel;
    private String select;
    protected PopupPanel popup = null;

    public AbstractCustomDropdown(String allItemsLabel) {
        this.allItemsLabel = allItemsLabel;
        HorizontalPanel p = new HorizontalPanel();
        p.setStyleName("CustomDropdown");
        this.box = new Label();
        this.box.setStyleName("CustomDropdown-TextBox");
        this.box.addClickHandler((ClickHandler)this);
        p.add((Widget)this.box);
        p.setCellWidth((Widget)this.box, "100%");
        this.button.setStyleName("CustomDropdown-DropButton");
        this.button.addClickHandler((ClickHandler)this);
        p.add((Widget)this.button);
        this.initWidget((Widget)p);
        this.createPopupPanel();
    }

    public String getAllItemsLabel() {
        return this.allItemsLabel;
    }

    public void setText(String select) {
        String oldSelect = this.select;
        this.select = select;
        this.box.setText(select);
        ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, (Object)oldSelect, (Object)select);
    }

    public String getText() {
        return this.select;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    protected void createPopupPanel() {
        this.popup = new PopupPanel(true);
        this.popup.setStyleName("CustomDropdown-PopupPanel");
        this.popup.addAutoHidePartner((Element)this.box.getElement());
        this.popup.addAutoHidePartner((Element)this.button.getElement());
        this.popup.setWidget((Widget)new Label("Loading..."));
        this.popup.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setPopupContent(Widget content) {
        this.popup.setWidget(content);
    }

    protected void displayPopup() {
        this.popup.showRelativeTo((UIObject)this.box);
    }

    public void onClick(ClickEvent event) {
        if (this.popup.isShowing()) {
            this.popup.hide();
        } else {
            this.displayPopup();
        }
    }

    protected void select(String selectedLabel) {
        this.setText(selectedLabel);
        this.popup.hide();
    }
}

