/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.search.client.rpc.InvalidSessionIdException;
import org.eaglei.search.client.rpc.SearchService;
import org.eaglei.search.config.SearchConfiguration;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;
import org.eaglei.search.server.SearchServlet;
import org.eaglei.search.server.security.SessionManager;

public class SearchServlet
extends RemoteServiceServlet
implements SearchService {
    private static final Log logger = LogFactory.getLog(SearchServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final String PROPERTIES_FILE = "eagle.i.search.properties";
    private static final String DEFAULT_PROPERTIES_FILE = "eagle-i-search.properties";
    private SearchProvider provider = null;
    private boolean providerInitialized = false;

    public void init() throws ServletException {
        SearchConfiguration config = this.getConfiguration();
        Thread initThread = new Thread((Runnable)new SearchProviderInitializer(this, config), "SearchProviderInitializer");
        initThread.setPriority(1);
        initThread.setDaemon(true);
        initThread.start();
    }

    private SearchConfiguration getConfiguration() throws ServletException {
        URL configURL;
        String propFile = System.getProperty(PROPERTIES_FILE);
        if (propFile == null) {
            propFile = DEFAULT_PROPERTIES_FILE;
        }
        if (DEBUG) {
            logger.debug((Object)("Using properties file " + propFile));
        }
        if ((configURL = this.getClass().getClassLoader().getResource(propFile)) == null) {
            logger.error((Object)("Could not locate " + propFile + " on classpath"));
            throw new ServletException();
        }
        try {
            File configFile = new File(configURL.toURI());
            return new SearchConfiguration(configFile);
        }
        catch (Exception e) {
            logger.error((Object)("Error loading configuration from " + configURL));
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] logIn(String username, String password) throws InvalidSessionIdException, LoggedException {
        SessionManager.authenticate((String)username, (String)password);
        try {
            String sessionId;
            SearchServlet searchServlet = this;
            synchronized (searchServlet) {
                sessionId = SessionManager.addSession((HttpServletResponse)this.getThreadLocalResponse());
            }
            return new String[]{username, sessionId};
        }
        catch (Throwable t) {
            logger.error((Object)"Unexpected exception", t);
            throw new LoggedException("Error during login: " + t.getLocalizedMessage());
        }
    }

    public void logOut(String sessionId) {
        try {
            SessionManager.removeSession((String)sessionId);
        }
        catch (Throwable e) {
            logger.error((Object)"Unexpected exception", e);
        }
    }

    public List<EIEntity> getInstitutions() throws LoggedException, InvalidSessionIdException {
        try {
            if (!this.providerInitialized) {
                if (DEBUG) {
                    logger.debug((Object)"Provider not yet initialized, returning empty institution list");
                }
                return Collections.EMPTY_LIST;
            }
            return new ArrayList<EIEntity>(this.provider.getInstitutions());
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getInstitutions", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    public SearchResultSet getSearchResults(String sessionId, SearchRequest request) throws LoggedException, InvalidSessionIdException {
        SessionManager.validate((String)sessionId);
        try {
            if (request == null) {
                logger.error((Object)"Null search request");
                throw new LoggedException();
            }
            if (DEBUG) {
                logger.debug((Object)request.toString());
            }
            if (!this.providerInitialized) {
                if (DEBUG) {
                    logger.debug((Object)"Provider not yet initialized, returning empty results");
                }
                return new SearchResultSet(request);
            }
            return this.provider.query(request);
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getSearchResults: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    static /* synthetic */ SearchProvider access$002(SearchServlet x0, SearchProvider x1) {
        x0.provider = x1;
        return x0.provider;
    }

    static /* synthetic */ SearchProvider access$000(SearchServlet x0) {
        return x0.provider;
    }

    static /* synthetic */ Log access$100() {
        return logger;
    }

    static /* synthetic */ boolean access$202(SearchServlet x0, boolean x1) {
        x0.providerInitialized = x1;
        return x0.providerInitialized;
    }
}

