/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.server.security;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.client.rpc.InvalidSessionIdException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionManager {
    private static final HashMap<String, Long> mapSessionIdToLastUse = new HashMap();
    private static final Log logger = LogFactory.getLog((String)SessionManager.class.getName());
    private static final String SYSTEM_USERNAME = System.getProperty("search.username");
    private static final String SYSTEM_PASSWORD = System.getProperty("search.password");
    public static final long EXPIRE_TIME = 1800000L;

    private static boolean allowHttpLogin() {
        String allowHttpLogin = System.getProperty("allow.http.login");
        return allowHttpLogin != null && Boolean.parseBoolean(allowHttpLogin);
    }

    public static void checkHttps(HttpServletRequest request) throws InvalidSessionIdException {
        if (!"https".equals(request.getScheme()) && !SessionManager.allowHttpLogin()) {
            throw new InvalidSessionIdException("https required");
        }
    }

    public static void authenticate(String username, String password) throws InvalidSessionIdException {
        if (SYSTEM_USERNAME != null && !SYSTEM_USERNAME.equals(username)) {
            throw new InvalidSessionIdException("Invalid username/password.");
        }
        if (SYSTEM_PASSWORD != null && !SYSTEM_PASSWORD.equals(password)) {
            throw new InvalidSessionIdException("Invalid username/password.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addSession(HttpServletResponse response) {
        SessionManager.removeExpiredSessions();
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        String sessionId = String.valueOf(bytes);
        Class<SessionManager> clazz = SessionManager.class;
        synchronized (SessionManager.class) {
            mapSessionIdToLastUse.put(sessionId, System.currentTimeMillis());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            logger.info((Object)("addSession: " + sessionId));
            Cookie c = new Cookie("SearchLogSID", sessionId);
            if (!SessionManager.allowHttpLogin()) {
                c.setSecure(true);
            }
            response.addCookie(c);
            return sessionId;
        }
    }

    public static void removeSession(HttpServletRequest request) {
        try {
            String sessionId = SessionManager.getSessionIdFromCookie((HttpServletRequest)request);
            SessionManager.removeSession((String)sessionId);
        }
        catch (InvalidSessionIdException invalidSessionIdException) {
            // empty catch block
        }
    }

    public static synchronized void removeSession(String sessionId) {
        if (sessionId != null) {
            mapSessionIdToLastUse.remove(sessionId);
            logger.info((Object)("removed session: " + sessionId));
        }
    }

    public static synchronized List<String> removeExpiredSessions() {
        ArrayList<String> invalid = new ArrayList<String>();
        for (String sessionId : mapSessionIdToLastUse.keySet()) {
            Long last = (Long)mapSessionIdToLastUse.get(sessionId);
            if (last + 1800000L >= System.currentTimeMillis()) continue;
            invalid.add(sessionId);
        }
        for (String sessionId : invalid) {
            SessionManager.removeSession((String)sessionId);
        }
        return invalid;
    }

    public static void validate(HttpServletRequest request) throws InvalidSessionIdException {
        SessionManager.checkHttps((HttpServletRequest)request);
        String sessionId = SessionManager.getSessionIdFromCookie((HttpServletRequest)request);
        SessionManager.validate((String)sessionId);
    }

    public static synchronized void validate(String sessionId) throws InvalidSessionIdException {
        if (sessionId == null) {
            if (SYSTEM_USERNAME != null || SYSTEM_PASSWORD != null) {
                throw new InvalidSessionIdException("Session id is required");
            }
            return;
        }
        Long last = (Long)mapSessionIdToLastUse.get(sessionId);
        if (last == null) {
            throw new InvalidSessionIdException("Session expired");
        }
        mapSessionIdToLastUse.put(sessionId, System.currentTimeMillis());
    }

    private static String getSessionIdFromCookie(HttpServletRequest request) throws InvalidSessionIdException {
        Cookie[] cookies;
        for (Cookie c : cookies = request.getCookies()) {
            if (!"SearchLogSID".equals(c.getName())) continue;
            return c.getValue();
        }
        throw new InvalidSessionIdException("Could not authenticate");
    }
}

