package org.eaglei.security;

import java.io.Serializable;

/**
 * User session representation. Includes edit permission levels.
 */
public class Session implements Serializable {

	private String	sessionId;
	private String	userName;
	private String	userURI;
	// Identifies the institution providing credentials
	// May be null in a single site app context.
	private String	institutionId;
	private Long lastAccess;

	private static final long serialVersionUID = 11438751692311L;

	// TBD
	//private int permissions;

	private Session() {
		// for GWT
	}

	public static boolean isValid(Session session) {
		if (session == null)
			return false;
		else
			return (session.getSessionId() != null && session.getSessionId().length() > 0) && (session.getUserURI() != null && session.getUserURI().length() > 0);

	}

	public Session(String sessionId, String institutionId, String userName, String userURI) {
		this.sessionId = sessionId;
		this.institutionId = institutionId;
		this.userName = userName;
		this.userURI = userURI;
		this.lastAccess = new Long(System.currentTimeMillis());
	}

	public String getInstitutionId() {
		return this.institutionId;
	}

	public String getUserName() {
		return this.userName;
	}

	public String getSessionId() {
		return this.sessionId;
	}

	public String getUserURI() {
		return this.userURI;
	}

	public Long getLastAccess() {
		return lastAccess;
	}

	public void setLastAccess(Long lastAccess) {
		this.lastAccess = lastAccess;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ( ( sessionId == null ) ? 0 : sessionId.hashCode() );
		result = prime * result + ( ( userName == null ) ? 0 : userName.hashCode() );
		result = prime * result + ( ( userURI == null ) ? 0 : userURI.hashCode() );
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if ( this == obj )
			return true;
		if ( obj == null )
			return false;
		if ( getClass() != obj.getClass() )
			return false;
		Session other = (Session)obj;
		if ( sessionId == null ) {
			if ( other.sessionId != null )
				return false;
		} else if ( !sessionId.equals( other.sessionId ) )
			return false;
		if ( userName == null ) {
			if ( other.userName != null )
				return false;
		} else if ( !userName.equals( other.userName ) )
			return false;
		if ( userURI == null ) {
			if ( other.userURI != null )
				return false;
		} else if ( !userURI.equals( other.userURI ) )
			return false;
		return true;
	}
	
	
}
