/*
 	(c) Copyright 2005, 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 	All rights reserved - see end of file.
 	$Id: ModelGetter.java,v 1.1 2009/06/29 08:55:38 castagna Exp $
*/

package com.hp.hpl.jena.rdf.model;

/**
    A ModelGetter object can retrieve a Model given a URL for it. If it doesn't
    have such a Model, it returns null.
<p>
    ModelGetters are very weakly constrained. They need not contain any
    models at all; they may forget models they have just delivered; they may
    deliver different models given the same URL. They <i>are</i> constrained to
    deliver an "appropriate" model for the URL, however - whatever they return
    should be strongly related to the RDF which might, at some time or another,
    be retrieved from that URL.
    
    @author kers
*/
public interface ModelGetter
    {
    /**
        Answer a Model whose content is that associated with the URL, if possible,
        and otherwise answer null.
    */
    public Model getModel( String URL );
    
    /**
        Answer a model appropriate for <code>URL</code>, If none is to hand,
        and it's possible to create one, create it and load it using <code>loadIfAbsent</code>.
        Otherwise throw CannotCreateException. This method never returns null.
    */
    public Model getModel( String URL, ModelReader loadIfAbsent );
    }


/*
 * (c) Copyright 2005, 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/