/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.security.SecurityProvider;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpClient;

public final class RepositorySecurityProvider
implements SecurityProvider {
    private static final Log log = LogFactory.getLog(RepositorySecurityProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private final Map<String, RepositoryHttpClient> mapInstIdToRepoClient = new HashMap<String, RepositoryHttpClient>();
    private Map<String, Session> mapIdToSession = new HashMap<String, Session>();
    private Map<String, HttpClient> mapIdToHttpClient = new HashMap<String, HttpClient>();

    public RepositorySecurityProvider() {
        RepositoryHttpClient config = new RepositoryHttpClient(System.getProperty("org.eaglei.subdomain"));
        this.mapInstIdToRepoClient.put(null, config);
    }

    public RepositorySecurityProvider(InstitutionRegistry institutionRegistry) {
        if (institutionRegistry.getInstitution() != null) {
            RepositoryHttpClient config = new RepositoryHttpClient(institutionRegistry.getSubdomain());
            this.mapInstIdToRepoClient.put(null, config);
            String uriStr = institutionRegistry.getMapSubdomainToURI().get(institutionRegistry);
            this.mapInstIdToRepoClient.put(uriStr, config);
        } else {
            for (Map.Entry<String, String> entry : institutionRegistry.getMapSubdomainToURI().entrySet()) {
                RepositoryHttpClient config = new RepositoryHttpClient(entry.getKey());
                this.mapInstIdToRepoClient.put(entry.getValue(), config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session logIn(String institutionId, String user, String password) {
        HttpClient client = this.getHttpClient(user, password);
        RepositoryHttpClient repoClient = this.mapInstIdToRepoClient.get(institutionId);
        if (repoClient == null) {
            log.error((Object)("Unrecognized login institution id: " + institutionId));
            return null;
        }
        int status = 0;
        ResultSet results = null;
        String responseBody = null;
        GetMethod method = new GetMethod(repoClient.getWhoamiUrl());
        try {
            if (isDebugEnabled) {
                log.debug((Object)("Authenticating user " + user + " at " + repoClient.getWhoamiUrl()));
            }
            status = client.executeMethod((HttpMethod)method);
            responseBody = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status != 200) {
                if (status == 404) {
                    log.error((Object)"Repo unavailable");
                } else if (status == 401) {
                    log.info((Object)("not authorized to get user information (login/whoami) : " + user));
                } else {
                    log.error((Object)responseBody);
                }
                Session session = null;
                return session;
            }
            results = ResultSetFactory.fromXML((String)responseBody);
            if (results == null) {
                log.error((Object)"whoami response body is null");
                Session session = null;
                return session;
            }
            QuerySolution soln = results.nextSolution();
            Literal username = soln.getLiteral("username");
            if (username == null) {
                log.error((Object)("Could not authenticate, null username in response body: " + user));
                Session session = null;
                return session;
            }
            Resource userURI = soln.getResource("uri");
            if (userURI == null) {
                log.error((Object)("Could not authenticate, null uri in response body: " + user));
                Session session = null;
                return session;
            }
            if (isDebugEnabled) {
                log.debug((Object)("Authenticated user: " + username.getString() + " " + userURI.getURI()));
            }
            String sessionId = UUID.randomUUID().toString();
            Session session = new Session(sessionId, institutionId, username.getString(), userURI.getURI());
            this.mapIdToSession.put(sessionId, session);
            this.mapIdToHttpClient.put(sessionId, client);
            Session session2 = session;
            return session2;
        }
        catch (Exception e) {
            log.error((Object)("problem getting user info " + repoClient.getWhoamiUrl() + " Message from repo: " + responseBody + "; Exception " + e));
            Session session = null;
            return session;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOut(String sessionId) {
        PostMethod method = null;
        try {
            HttpClient client = this.mapIdToHttpClient.get(sessionId);
            Session session = this.mapIdToSession.get(sessionId);
            if (client == null) {
                return;
            }
            if (session == null) {
                return;
            }
            RepositoryHttpClient repoClient = this.mapInstIdToRepoClient.get(session.getInstitutionId());
            method = new PostMethod(repoClient.getLogoutUrl());
            int status = 0;
            if (isDebugEnabled) {
                log.debug((Object)("Trying to logout at " + repoClient.getLogoutUrl()));
            }
            if ((status = client.executeMethod((HttpMethod)method)) == 200) {
                if (isDebugEnabled) {
                    log.debug((Object)"logout succeded");
                }
            } else {
                log.info((Object)("Could not logout user: HTTP Status: " + status));
            }
        }
        catch (Exception e) {
            log.error((Object)("Unexpected error during logout  " + e));
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            this.mapIdToHttpClient.remove(sessionId);
            this.mapIdToSession.remove(sessionId);
        }
    }

    private HttpClient getHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    public Session getSession(String sessionId) {
        return this.mapIdToSession.get(sessionId);
    }
}

