/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.services.repository.SPARQLConstants;
import org.eaglei.services.repository.SPARQLOntConstants;

public class SPARQLQueryUtil
implements SPARQLOntConstants,
SPARQLConstants {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);

    public static EIEntity getStatusEntity(EIURI statusUri) {
        if (statusUri == null) {
            return EIEntity.NULL_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Draft".equals(statusUri.toString())) {
            return DRAFT_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Curation".equals(statusUri.toString())) {
            return CURATION_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Published".equals(statusUri.toString())) {
            return PUBLISH_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn".equals(statusUri.toString())) {
            return WITHDRAW_ENTITY;
        }
        return EIEntity.NULL_ENTITY;
    }

    public static String getReferencedByQuery(EIURI resourceUri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(SPARQLQueryUtil.namespaces());
        sparql.append(SPARQLQueryUtil.selectClause());
        sparql.append(SPARQLQueryUtil.commonPattern());
        sparql.append(SPARQLQueryUtil.typePattern());
        sparql.append(SPARQLQueryUtil.referencedByPattern(resourceUri));
        sparql.append(SPARQLQueryUtil.closingClause());
        return sparql.toString();
    }

    public static String referencedByPattern(EIURI resourceUri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?");
        sparql.append("r_subject");
        sparql.append(" ?anyPredicate <");
        sparql.append(resourceUri.toString());
        sparql.append("> . ");
        return sparql.toString();
    }

    private static String namespaces() {
        StringBuilder namespaces = new StringBuilder();
        namespaces.append("PREFIX dcterms: <");
        namespaces.append("http://purl.org/dc/terms/");
        namespaces.append("> ");
        namespaces.append("PREFIX rdf: <");
        namespaces.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        namespaces.append("> ");
        namespaces.append("PREFIX rdfs: <");
        namespaces.append("http://www.w3.org/2000/01/rdf-schema#");
        namespaces.append("> ");
        namespaces.append("PREFIX repo: <");
        namespaces.append("http://eagle-i.org/ont/repo/1.0/");
        namespaces.append("> ");
        return namespaces.toString();
    }

    private static String selectClause() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT DISTINCT ");
        sparql.append("?anyPredicate ");
        for (String variable : resultSetVariables) {
            sparql.append("?");
            sparql.append(variable);
            sparql.append(" ");
        }
        sparql.append("WHERE {");
        return sparql.toString();
    }

    private static String commonPattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?");
        sparql.append("r_subject");
        sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
        sparql.append("r_label");
        sparql.append(" . ?");
        sparql.append("r_subject");
        sparql.append(" dcterms:created ?");
        sparql.append("r_date");
        sparql.append(" . ");
        return sparql.toString();
    }

    private static String typePattern() {
        return "graph ?g{?r_subject a ?r_type} filter(?g != repo:NG_Inferred) . ";
    }

    public static String allTypesPattern(boolean excludeSomeTypes) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?");
        sparql.append("r_subject");
        sparql.append(" a ?rt . ");
        sparql.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> ");
        if (excludeSomeTypes) {
            sparql.append("filter(?rt != <");
            sparql.append("http://purl.obolibrary.org/obo/OBI_0000245");
            sparql.append("> && ?rt != <");
            sparql.append("http://xmlns.com/foaf/0.1/Person");
            sparql.append(">) .");
        }
        return sparql.toString();
    }

    private static String ownerRestrictionPattern(String user, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        if (strictOwnerFilter) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowOwner ?");
            sparql.append("r_owner");
            sparql.append(". FILTER(?");
            sparql.append("r_owner");
            sparql.append("= <");
        } else {
            sparql.append("OPTIONAL {?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowOwner ?");
            sparql.append("r_owner");
            sparql.append("} . FILTER(!bound(?");
            sparql.append("r_owner");
            sparql.append(") || ?");
            sparql.append("r_owner");
            sparql.append(" = <");
        }
        sparql.append(user);
        sparql.append(">) . ");
        return sparql.toString();
    }

    private static String typeRestrictionPattern(EIURI classUri, boolean excludeSomeTypes) {
        StringBuilder sparql = new StringBuilder();
        if (!SPARQLQueryUtil.isNull(classUri)) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" a <");
            sparql.append(classUri.toString());
            sparql.append("> .");
        } else {
            sparql.append(SPARQLQueryUtil.allTypesPattern(excludeSomeTypes));
        }
        return sparql.toString();
    }

    private static String stateRestrictionPattern(EIURI state) {
        StringBuilder sparql = new StringBuilder();
        if (!SPARQLQueryUtil.isNull(state)) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowState <");
            sparql.append(state.toString());
            sparql.append("> . ?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowState ?");
            sparql.append("r_state");
            sparql.append(" . ");
        } else {
            sparql.append("OPTIONAL {?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowState ?");
            sparql.append("r_state");
            sparql.append("} . ");
        }
        return sparql.toString();
    }

    public static String labRestrictionPattern(EIURI lab) {
        StringBuilder sparql = new StringBuilder();
        if (!SPARQLQueryUtil.isNull(lab)) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" ?labProperty ?");
            sparql.append("r_lab");
            sparql.append(" . ?");
            sparql.append("r_lab");
            sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
            sparql.append("r_labName");
            sparql.append(" . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . filter(?");
            sparql.append("r_lab");
            sparql.append(" = <");
            sparql.append(lab.toString());
            sparql.append(">) . ");
        } else {
            sparql.append("OPTIONAL {?");
            sparql.append("r_subject");
            sparql.append(" ?labProperty ?");
            sparql.append("r_lab");
            sparql.append(" . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . ?");
            sparql.append("r_lab");
            sparql.append(" a <");
            sparql.append("http://purl.obolibrary.org/obo/ERO_0000001");
            sparql.append("> . ?");
            sparql.append("r_lab");
            sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
            sparql.append("r_labName");
            sparql.append("} . ");
        }
        return sparql.toString();
    }

    private static String closingClause() {
        return "} order by repo:upperCaseStr(?r_label)";
    }

    private static boolean isNull(EIURI uri) {
        return uri == null || uri.equals((Object)EIURI.NULL_EIURI) || "".equals(uri.toString());
    }

    public static List<EIInstanceMinimal> createReferencedByInstances(EIOntModel ontModel, EIInstance objectInstance, ResultSet resultSet) {
        if (resultSet == null) {
            return Collections.EMPTY_LIST;
        }
        List objInstProperties = ontModel.getProperties(objectInstance.getInstanceType().getURI());
        HashMap<EIURI, EIInstanceMinimal> instances = new HashMap<EIURI, EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        while (resultSet.hasNext()) {
            EIInstanceMinimal ei;
            QuerySolution solution = resultSet.next();
            if (!solution.contains("r_subject") || !solution.contains("r_type") || !solution.contains("r_label")) continue;
            EIURI instanceUri = SPARQLQueryUtil.getUriFromSolution(solution, "r_subject");
            EIURI instanceType = SPARQLQueryUtil.getUriFromSolution(solution, "r_type");
            String label = SPARQLQueryUtil.getStringFromSolution(solution, "r_label");
            if (SPARQLQueryUtil.safeGetClass(ontModel, instanceType) == null) continue;
            EIEntity instanceEntity = EIEntity.create((EIURI)instanceUri, (String)label);
            boolean inferredValue = false;
            EIURI referencePredicate = SPARQLQueryUtil.getUriFromSolution(solution, "anyPredicate");
            if (referencePredicate != EIURI.NULL_EIURI) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Referencing property: " + referencePredicate));
                }
                String referencePredicateStr = referencePredicate.toString();
                for (EIProperty objInstProperty : objInstProperties) {
                    String inverseProperty;
                    if (!(objInstProperty instanceof EIObjectProperty) || !referencePredicateStr.equals(inverseProperty = ((EIObjectProperty)objInstProperty).getInverseURI())) continue;
                    Set values = objectInstance.getObjectProperty(objInstProperty.getEntity());
                    inferredValue = true;
                    if (values != null && values.contains(instanceEntity)) continue;
                    objectInstance.addObjectProperty(objInstProperty.getEntity(), instanceEntity);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Inferred inverse property: " + objInstProperty.getEntity() + "   value: " + instanceEntity));
                    break;
                }
            }
            if (inferredValue) continue;
            if (!instances.containsKey(instanceUri)) {
                ei = SPARQLQueryUtil.createEmptyMinimal(ontModel, instanceType, instanceEntity);
                instances.put(instanceUri, ei);
                instanceList.add(ei);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating new EIInstance: " + ei));
                }
            } else {
                ei = (EIInstanceMinimal)instances.get(instanceUri);
                ei.addEIType(EIEntity.create((EIURI)instanceType, (String)""));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding type: " + instanceType + " to existing EIInstance :" + ei));
                }
            }
            ei.setWFOwner(SPARQLQueryUtil.getEntityFromSolution(solution, "r_owner", "r_ownerName"));
            ei.setWFState(SPARQLQueryUtil.getEntityFromSolution(solution, "r_state", ""));
            ei.setCreationDate(SPARQLQueryUtil.getStringFromSolution(solution, "r_date"));
            ei.setLab(SPARQLQueryUtil.getEntityFromSolution(solution, "r_lab", "r_labName"));
        }
        return instanceList;
    }

    private static EIInstanceMinimal createEmptyMinimal(EIOntModel ontModel, EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = SPARQLQueryUtil.safeGetClass(ontModel, typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstanceMinimal ei = EIInstanceMinimal.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        return ei;
    }

    private static EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create((String)solution.getResource(uriVariable).getURI());
            if ("r_state".equals(uriVariable)) {
                return SPARQLQueryUtil.getStatusEntity(uri);
            }
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create((EIURI)uri, (String)label);
        }
        return EIEntity.NULL_ENTITY;
    }

    private static EIURI getUriFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return EIURI.create((String)solution.getResource(variable).getURI());
        }
        return EIURI.NULL_EIURI;
    }

    private static String getStringFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString();
        }
        return "";
    }

    private static EIClass safeGetClass(EIOntModel ontModel, EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }
}

