/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.security.SecurityProvider;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpConfig;

public final class RepositorySecurityProvider
implements SecurityProvider {
    private static final Long SESSION_TIMEOUT = Long.getLong("org.eaglei.session.timeout", 1800000L);
    private static final Log log = LogFactory.getLog(RepositorySecurityProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private final InstitutionRegistry institutionRegistry;
    private Map<String, SessionInternal> mapSessionIdToSession = new HashMap<String, SessionInternal>();

    public RepositorySecurityProvider(InstitutionRegistry institutionRegistry) {
        this.institutionRegistry = institutionRegistry;
        SessionReaper reaper = new SessionReaper();
        reaper.start();
        log.info((Object)("RepositorySecurityProvider initialized.  Session timeout:  " + SESSION_TIMEOUT / 60000L + " min"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session logIn(String institutionId, String user, String password) {
        HttpClient userClient = RepositoryHttpConfig.createHttpClient(user, password);
        userClient.setHttpConnectionManager((HttpConnectionManager)new SimpleHttpConnectionManager(true));
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(institutionId);
        if (repoConfig == null) {
            log.error((Object)("Unrecognized login institution id: " + institutionId));
            return null;
        }
        int status = 0;
        ResultSet results = null;
        String responseBody = null;
        GetMethod method = new GetMethod(repoConfig.getWhoamiUrl());
        try {
            if (isDebugEnabled) {
                log.debug((Object)("Authenticating user " + user + " at " + repoConfig.getWhoamiUrl()));
            }
            status = userClient.executeMethod((HttpMethod)method);
            responseBody = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status != 200) {
                if (status == 404) {
                    log.error((Object)"Repo unavailable");
                } else if (status == 401) {
                    log.info((Object)("not authorized to get user information (login/whoami) : " + user));
                } else {
                    log.error((Object)responseBody);
                }
                Session session = null;
                return session;
            }
            results = ResultSetFactory.fromXML((String)responseBody);
            if (results == null) {
                log.error((Object)"whoami response body is null");
                Session session = null;
                return session;
            }
            QuerySolution soln = results.nextSolution();
            Literal username = soln.getLiteral("username");
            if (username == null) {
                log.error((Object)("Could not authenticate, null username in response body: " + user));
                Session session = null;
                return session;
            }
            Resource userURI = soln.getResource("uri");
            if (userURI == null) {
                log.error((Object)("Could not authenticate, null uri in response body: " + user));
                Session session = null;
                return session;
            }
            String sessionId = UUID.randomUUID().toString();
            Session session = new Session(sessionId, institutionId, username.getString(), userURI.getURI());
            SessionInternal sessionInternal = new SessionInternal();
            sessionInternal.session = session;
            sessionInternal.lastAccess = new Long(System.currentTimeMillis());
            sessionInternal.httpClient = userClient;
            this.mapSessionIdToSession.put(sessionId, sessionInternal);
            if (isDebugEnabled) {
                log.debug((Object)("Authenticated user: " + sessionInternal.session.getUserName() + " session id: " + sessionId));
            }
            Session session2 = session;
            return session2;
        }
        catch (Exception e) {
            log.error((Object)("problem getting user info " + repoConfig.getWhoamiUrl() + " Message from repo: " + responseBody + "; Exception " + e));
            Session session = null;
            return session;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOut(String sessionId) {
        SessionInternal sessionInternal = this.removeSession(sessionId);
        if (sessionInternal == null) {
            return;
        }
        PostMethod method = null;
        try {
            RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(sessionInternal.session.getInstitutionId());
            method = new PostMethod(repoConfig.getLogoutUrl());
            int status = 0;
            if (isDebugEnabled) {
                log.debug((Object)("Trying to logout at " + repoConfig.getLogoutUrl()));
            }
            if ((status = sessionInternal.httpClient.executeMethod((HttpMethod)method)) == 200) {
                if (isDebugEnabled) {
                    log.debug((Object)"logout succeded");
                }
            } else {
                log.info((Object)("Could not logout user: HTTP Status: " + status));
            }
        }
        catch (HttpException e) {
            log.warn((Object)("Error on logout: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)("Error on logout: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInternal removeSession(String sessionId) {
        Map<String, SessionInternal> map = this.mapSessionIdToSession;
        synchronized (map) {
            SessionInternal sessionInternal = this.mapSessionIdToSession.remove(sessionId);
            if (sessionInternal == null) {
                return null;
            }
            if (isDebugEnabled) {
                log.debug((Object)("Remove session for user: " + sessionInternal.session.getUserName() + " session id: " + sessionId));
            }
            return sessionInternal;
        }
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sessionId) {
        Map<String, SessionInternal> map = this.mapSessionIdToSession;
        synchronized (map) {
            SessionInternal sessionInternal = this.mapSessionIdToSession.get(sessionId);
            if (sessionInternal == null) {
                return null;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime > sessionInternal.lastAccess + SESSION_TIMEOUT) {
                this.removeSession(sessionId);
                return null;
            }
            sessionInternal.lastAccess = currentTime;
            return sessionInternal.session;
        }
    }

    public boolean isValid(String sessionId) {
        return this.getSession(sessionId) != null;
    }

    private class SessionReaper
    extends Thread {
        SessionReaper() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(SESSION_TIMEOUT);
                }
                catch (InterruptedException e) {
                    return;
                }
                Map map = RepositorySecurityProvider.this.mapSessionIdToSession;
                synchronized (map) {
                    ArrayList sessionList = new ArrayList(RepositorySecurityProvider.this.mapSessionIdToSession.keySet());
                    for (String sessionId : sessionList) {
                        RepositorySecurityProvider.this.getSession(sessionId);
                    }
                }
            }
        }
    }

    private static class SessionInternal {
        Session session;
        Long lastAccess;
        HttpClient httpClient;

        private SessionInternal() {
        }
    }
}

