/**
 * The eagle-i consortium
 * Harvard University
 * Nov 5, 2010
 */
package org.eaglei.services.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.io.IOUtils;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class ProviderUtils {
    public static String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        //encoding needs to be explicitly set
        IOUtils.copy(in, writer, "UTF-8");
        return writer.toString();
    }
    
    /**
	 * Convenience method for dealing with the most general cases of http request/response 
	 * 
	 * @param client
	 * @param method
	 * @return the string returned by the repo
	 * @throws HttpException
	 * @throws IOException
	 * @throws RepositoryProviderException
	 * @throws NotFoundException 
	 * @throws UnauthorizedException 
	 * @throws ConflictException 
	 * @throws InternalServerErrorException 
	 */
	public static String getHttpResponse(final HttpClient client, final HttpMethod method) throws RepositoryProviderException {
		int status = 0;

		String responseBody;
		try {
			status = client.executeMethod( method );
			responseBody = ProviderUtils.getStringFromInputStream( method.getResponseBodyAsStream() );
		} catch (final HttpException e) {
			throw new RepositoryProviderException("HttpException of unknown origin");
		} catch (IOException e1) {
			throw new RepositoryProviderException("I/O Exception of unknown origin");
		} finally {
			method.releaseConnection();
		}

		if ( status == HttpStatus.SC_OK || status == HttpStatus.SC_CREATED ) {
			// + " response: " + responseBody );
			return responseBody;
		} else { 
			throw new RepositoryProviderException( "Operation failed with status: " + status + " response: " + responseBody );
		}
	}
}
