/**
 * The eagle-i consortium
 * Harvard University
 * Feb 15, 2011
 */
package org.eaglei.services.repository;

import org.apache.commons.httpclient.HttpClient;
import org.eaglei.security.Session;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class RepositorySession {
	private final Session session;
    private final HttpClient httpClient;
    
    
    public RepositorySession(Session session, HttpClient httpClient) {
    	this.session = session;
    	this.httpClient = httpClient;
    }
    
    public String getInstitutionId() {
		return session.getInstitutionId();
	}

	public String getUserName() {
		return session.getUserName();
	}

	public String getSessionId() {
		return session.getSessionId();
	}

	public String getUserURI() {
		return session.getUserURI();
	}

	public Long getLastAccess() {
		return session.getLastAccess();
	}

	public void setLastAccess(Long lastAccess) {
		session.setLastAccess( lastAccess );
	}
	
	public HttpClient getHttpClient() {
		setLastAccess( new Long(System.currentTimeMillis()) );
		return this.httpClient;
	}
	
	public boolean isValid() {
		return httpClient != null && Session.isValid(session);
	}
	
	public Session getInnerSession() {
		return session;
	}
}
