package org.eaglei.services.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRepositoryProvider {
	
	// string sent as part of http requests
	protected static final String FORMAT_VALUE = "application/xml";

	// format string used for all Jena calls
	protected static final Log log = LogFactory.getLog( AbstractRepositoryProvider.class );
	protected static final boolean isDebugEnabled = log.isDebugEnabled();

	public static final String LABEL_QUERY_FAILED = "could not retrieve label";
	
	// Workflow Variable Names
	protected static final String WORKFLOW_TRANSITION_SUBJECT = "subject";
	protected static final String WORKFLOW_TRANSITION_LABEL = "label";
	protected static final String WORKFLOW_TRANSITION_FROM = "initial";
	protected static final String WORKFLOW_TRANSITION_FROM_LABEL = "initialLabel";
	protected static final String WORKFLOW_TRANSITION_TO = "final";
	protected static final String WORKFLOW_TRANSITION_TO_LABEL = "finalLabel";
	protected static final String WORKFLOW_TRANSITION_ALLOWED = "allowed";
	
	protected static String DEFAULT_REPOSITORY_URL;
	protected static String DEFAULT_REPOSITORY_URI;

	protected enum RestCommands {
		// IMPORTANT logout needs a / at the end
		GetNewInstanceIDs("repository/new"), WhoAmI("repository/whoami"), Logout("repository/logout/"), GetInstance("repository/resource"), UpdateInstance("repository/update"), Query("repository/sparql"), Online(""), Graph("repository/graph"), FakeWorkflow(
				"repository/fakeworkflow"), Listgraphs("repository/listGraphs"), Claim("repository/workflow/claim"), Release("repository/workflow/release"), Transition("repository/workflow/push"), ListTransitions("repository/workflow/transitions"), ListResources(
				"repository/workflow/resources");

		private RestCommands(final String propKey) {
			key = propKey;
		}

		public String getURL() {
			return DEFAULT_REPOSITORY_URL + key;
		}

		private final String key;
	}

}
