/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceFactory;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.SearchEIInstancePreview;
import org.eaglei.model.jena.EIInstanceMinimalFactory;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.NodeConfig;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositorySecurityProvider;

public class RepositoryInstanceProvider {
    private static final Log log = LogFactory.getLog(RepositoryInstanceProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String NO_SESSION_MESSAGE = "No session information was found.";
    private static final String FAILURE_MESSAGE = "Could not complete operation; repository message is: ";
    protected static final String READ_VIEW = "user";
    private static final String FORMAT_VALUE = "application/xml";
    private static final String RDF_FORMAT = "RDF/XML";
    private final EIOntModel eiOntModel;
    private final RepositorySecurityProvider securityProvider;
    private final EIInstanceFactory instanceFactory;
    private final EIInstanceMinimalFactory minimalFactory;
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private Map<String, RepositoryHttpConfig> mapHostToRepoConfig = new HashMap<String, RepositoryHttpConfig>();
    private Map<String, HttpClient> mapHostToHttpClient = new HashMap<String, HttpClient>();
    private HttpClient httpclient;
    private final ConnectionReaper connectionReaper = new ConnectionReaper();

    public RepositoryInstanceProvider(EIOntModel eiOntModel, RepositorySecurityProvider provider, InstitutionRegistry registry) {
        this.connectionReaper.start();
        this.eiOntModel = eiOntModel;
        this.securityProvider = provider;
        this.instanceFactory = new JenaEIInstanceFactory(eiOntModel);
        this.minimalFactory = new EIInstanceMinimalFactory(eiOntModel);
        for (NodeConfig nodeConfig : registry.getNodeConfigs()) {
            RepositoryHttpConfig repoConfig = registry.getRepositoryHttpConfig(nodeConfig.getUri());
            String hostURL = repoConfig.getHostURL();
            hostURL = hostURL.replace("https", "http");
            this.httpclient = RepositoryHttpConfig.createHttpClient(repoConfig.getSearchUsername(), repoConfig.getSearchPassword());
            this.httpclient.setHttpConnectionManager((HttpConnectionManager)this.connectionManager);
            nodeConfig.getRepositoryHostUrl();
            this.mapHostToRepoConfig.put(hostURL, repoConfig);
            this.mapHostToHttpClient.put(hostURL, this.httpclient);
        }
    }

    public Map<EIURI, String> getToolTips(String sessionID, EIURI instanceID) throws Exception {
        this.securityProvider.isValid(sessionID, true);
        if (instanceID == null || instanceID.toString() == null) {
            log.warn((Object)"Trying to get instance for null EIURI");
            return null;
        }
        String instanceIDStr = instanceID.toString();
        RepositoryHttpConfig repoConfig = this.getRepoConfigFromInstanceId(instanceIDStr);
        if (repoConfig == null) {
            log.error((Object)("Unrecognized resource instance URL:  " + instanceIDStr));
            throw new Exception("Unrecognized resource instance URL:  " + instanceIDStr);
        }
        String host = instanceIDStr.substring(0, instanceIDStr.indexOf("/i/") + 1);
        HttpClient searchHttpClient = this.mapHostToHttpClient.get(host);
        int status = 0;
        PostMethod method = new PostMethod(repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.SEARCH_INSTANCE_URL));
        this.setReadParameters(method);
        method.setParameter("uri", instanceIDStr);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceID.toString()));
        }
        try {
            status = searchHttpClient.executeMethod((HttpMethod)method);
            if (status == 200) {
                Map<EIURI, String> mapTermToDefinition;
                String response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
                EIInstance instance = this.instanceFactory.create(instanceID, response, RDF_FORMAT);
                if (isDebugEnabled) {
                    log.debug((Object)("got instance contents: " + instance));
                }
                Map<EIURI, String> map = mapTermToDefinition = this.getTerms(instance);
                return map;
            }
            log.error((Object)("get instance " + instanceID + " failed with status: " + status));
            throw new RepositoryProviderException("Could not complete operation; repository message is: get instance, " + status);
        }
        finally {
            method.releaseConnection();
            this.connectionManager.closeIdleConnections(1800000L);
        }
    }

    public RepositoryHttpConfig getRepoConfigFromInstanceId(String instanceIDStr) {
        String host = instanceIDStr.substring(0, instanceIDStr.indexOf("/i/") + 1);
        RepositoryHttpConfig repoConfig = this.mapHostToRepoConfig.get(host);
        return repoConfig;
    }

    public SearchEIInstancePreview getObjectPropertyValuePreview(String sessionID, EIURI instanceUri) throws RepositoryProviderException {
        if (!this.securityProvider.isValid(sessionID, false)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new RepositoryProviderException(NO_SESSION_MESSAGE);
        }
        if (instanceUri == null || instanceUri.toString() == null || EIURI.NULL_EIURI.equals((Object)instanceUri)) {
            log.warn((Object)"Trying to get instance for null EIURI");
            throw new RepositoryProviderException("Trying to get instance for null EIURI");
        }
        PostMethod method = new PostMethod(this.getRepoConfigFromInstanceId(instanceUri.toString()).getHostURL() + RestCommands.GetInstance.getURL());
        this.setReadParameters(method);
        method.setParameter("uri", instanceUri.toString());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceUri.toString()));
        }
        String responseBody = ProviderUtils.getHttpResponse(this.httpclient, (HttpMethod)method);
        EIInstance eiInstance = this.instanceFactory.create(instanceUri, responseBody, RDF_FORMAT);
        return new SearchEIInstancePreview(eiInstance);
    }

    public EIInstance getEIInstance(String sessionID, EIURI instanceUri) throws RepositoryProviderException {
        String responseBody;
        EIInstance eiInstance;
        this.securityProvider.isValid(sessionID, true);
        if (instanceUri == null || instanceUri.toString() == null || EIURI.NULL_EIURI.equals((Object)instanceUri)) {
            log.warn((Object)"Trying to get instance for null EIURI");
            throw new RepositoryProviderException("Trying to get instance for null EIURI");
        }
        PostMethod method = new PostMethod(this.getRepoConfigFromInstanceId(instanceUri.toString()).getHostURL() + RestCommands.GetInstance.getURL());
        this.setReadParameters(method);
        method.setParameter("uri", instanceUri.toString());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceUri.toString()));
        }
        if (this.isNull(eiInstance = this.instanceFactory.createExtended(instanceUri, responseBody = ProviderUtils.getHttpResponse(this.httpclient, (HttpMethod)method), RDF_FORMAT))) {
            throw new RepositoryProviderException("Unable to create EIInstance for instanceUri: " + instanceUri);
        }
        eiInstance.setStubs(this.getAllStubEntities(sessionID, eiInstance));
        return eiInstance;
    }

    protected Set<EIEntity> getAllStubEntities(String sessionID, EIInstance instance) throws RepositoryProviderException {
        Set<EIEntity> stubs = this.getStubEntities(sessionID, instance.getInstanceURI());
        if (instance.hasEmbeddedInstances()) {
            for (EIURI embeddedUri : instance.getEmbeddedInstanceUriList()) {
                stubs.addAll(this.getStubEntities(sessionID, embeddedUri));
            }
        }
        return stubs;
    }

    public List<EIInstanceMinimal> listReferencingResources(String sessionID, String userURI, EIURI resourceUri, AuthSearchRequest queryRequest, boolean strictOwnerFilter) throws RepositoryProviderException {
        this.securityProvider.isValid(sessionID, true);
        PostMethod method = new PostMethod(this.getRepoConfigFromInstanceId(resourceUri.toString()).getHostURL() + RestCommands.ListResources.getURL());
        method.setParameter("state", "all");
        StringBuilder sparql = new StringBuilder();
        sparql.append(SPARQLQueryUtil.getInstance().allTypesPattern(false));
        sparql.append(SPARQLQueryUtil.getInstance().providerRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(SPARQLQueryUtil.getInstance().referencedByPattern(resourceUri));
        this.commonListResourcesMethodSetup(EIURI.create((String)userURI), queryRequest, "", strictOwnerFilter, sparql, method);
        ResultSet resultSet = ResultSetFactory.fromXML((String)ProviderUtils.getHttpResponse(this.httpclient, (HttpMethod)method));
        List results = this.minimalFactory.create(resultSet);
        return results;
    }

    private void commonListResourcesMethodSetup(EIURI user, AuthSearchRequest queryRequest, String sortOrder, boolean strictOwnerFilter, StringBuilder sparql, PostMethod method) {
        method.setParameter("detail", "full");
        method.setParameter("format", FORMAT_VALUE);
        if (strictOwnerFilter) {
            method.setParameter("owner", "self");
            method.setParameter("unclaimed", "false");
        } else {
            method.setParameter("owner", "all");
            method.setParameter("unclaimed", "true");
        }
        sparql.append(SPARQLQueryUtil.getInstance().modifiedDatePattern());
        sparql.append(" filter(!regex(str(?").append("r_created").append("), \"http://www.w3.org/2001/XMLSchema#dateTime\"))");
        sparql.append(" filter(bound(?").append("r_label").append("))");
        if (isDebugEnabled) {
            log.debug((Object)("Sparql pattern sent to workflow/resources is: " + sparql.toString()));
        }
        try {
            method.setParameter("addPattern", this.encodeToUTF8(sparql.toString()));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("could not encode to utf-8: " + e.getMessage()));
            log.warn((Object)("will send unencoded query string pattern: " + sparql.toString()));
            method.setParameter("addPattern", sparql.toString());
        }
        method.setParameter("addResults", "?r_provider ?r_providerName ?r_last_modified ?r_is_stub");
        StringBuilder modifiers = new StringBuilder();
        method.setParameter("addModifiers", modifiers.toString());
        if (isDebugEnabled) {
            log.debug((Object)("modifiers sent to workflow/resources are: " + modifiers.toString()));
        }
    }

    private Set<EIEntity> getStubEntities(String sessionID, EIURI instanceUri) throws RepositoryProviderException {
        ResultSet results = ResultSetFactory.fromXML((String)this.postQuery(sessionID, SPARQLQueryUtil.getInstance().getRetrieveStubsQuery(instanceUri), instanceUri.toString()));
        HashSet<EIEntity> stubs = new HashSet<EIEntity>();
        while (results.hasNext()) {
            QuerySolution solution = results.nextSolution();
            if (!solution.contains("r_subject") || !solution.contains("r_label")) continue;
            EIURI uri = EIURI.create((String)solution.getResource("r_subject").getURI());
            String label = solution.getLiteral("r_label").getString();
            stubs.add(EIEntity.create((EIURI)uri, (String)label));
        }
        return stubs;
    }

    private boolean isNull(EIInstance instance) {
        return instance == null || instance.getInstanceURI() == null || EIInstance.NULL_INSTANCE.equals(instance);
    }

    public EIInstance setReferencingResources(String sessionId, EIInstance instance) throws RepositoryProviderException {
        ResultSet results = ResultSetFactory.fromXML((String)this.postQuery(sessionId, SPARQLQueryUtil.getInstance().getReferencedByQuery(instance.getInstanceURI()), instance.getInstanceURI().toString()));
        this.minimalFactory.setReferencingInstances(instance, results);
        return instance;
    }

    private synchronized String postQuery(String sessionId, String q, String instanceID) throws RepositoryProviderException {
        return this.postQuery(sessionId, q, READ_VIEW, instanceID);
    }

    private synchronized String postQuery(String sessionId, String q, String view, String instanceID) throws RepositoryProviderException {
        this.securityProvider.isValid(sessionId, true);
        if (q == null) {
            log.warn((Object)"Null query!");
            return null;
        }
        PostMethod method = new PostMethod(this.getRepoConfigFromInstanceId(instanceID).getHostURL() + RestCommands.Query.getURL());
        this.setReadParameters(method);
        method.setParameter("view", view);
        try {
            method.setParameter("query", this.encodeToUTF8(q));
        }
        catch (Exception e) {
            log.warn((Object)("could not encode to utf-8: " + e.getMessage()));
            log.warn((Object)("will send unencoded query string: " + q));
            method.setParameter("query", q);
        }
        return ProviderUtils.getHttpResponse(this.httpclient, (HttpMethod)method);
    }

    private String encodeToUTF8(String rdfString) throws UnsupportedEncodingException {
        return new String(rdfString.getBytes("UTF-8"));
    }

    private Map<EIURI, String> getTerms(EIInstance instance) {
        HashMap<EIURI, String> mapTermToDefinition = null;
        EIClass eiClass = instance.getInstanceClass();
        List properties = this.eiOntModel.getProperties(eiClass.getEntity().getURI());
        for (Map.Entry entry : instance.getObjectProperties().entrySet()) {
            List<EIEntity> listTermRanges = this.getTermRanges((EIEntity)entry.getKey(), properties);
            if (listTermRanges == null) continue;
            for (EIEntity value : (Set)entry.getValue()) {
                if (!this.isTermType(value, listTermRanges)) continue;
                if (mapTermToDefinition == null) {
                    mapTermToDefinition = new HashMap();
                }
                mapTermToDefinition.put(value.getURI(), this.eiOntModel.getClassDefinition(value.getURI()));
            }
        }
        if (this.eiOntModel.getClassDefinition(instance.getInstanceType().getURI()) != null) {
            if (mapTermToDefinition == null) {
                mapTermToDefinition = new HashMap<EIURI, String>();
            }
            mapTermToDefinition.put(instance.getInstanceType().getURI(), this.eiOntModel.getClassDefinition(instance.getInstanceType().getURI()));
        }
        return mapTermToDefinition;
    }

    private List<EIEntity> getTermRanges(EIEntity propEntity, List<EIProperty> properties) {
        for (EIProperty p : properties) {
            if (!p.getEntity().equals((Object)propEntity)) continue;
            EIObjectProperty objProperty = (EIObjectProperty)p;
            ArrayList<EIEntity> termRanges = new ArrayList<EIEntity>(objProperty.getRangeList().size());
            for (EIClass rangeClass : objProperty.getRangeList()) {
                if (rangeClass.isEagleIResource()) continue;
                termRanges.add(rangeClass.getEntity());
            }
            return termRanges;
        }
        return null;
    }

    private boolean isTermType(EIEntity value, List<EIEntity> listTermRanges) {
        for (EIEntity range : listTermRanges) {
            if (range.equals((Object)value)) {
                return true;
            }
            if (!this.eiOntModel.isSubClass(range.getURI(), value.getURI())) continue;
            return true;
        }
        return false;
    }

    private void setReadParameters(PostMethod method) {
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("view", READ_VIEW);
        method.setParameter("noinferred", "true");
        method.setRequestHeader("charset", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contactMessage(String sessionID, String client_ip, EIURI instanceID, String label, boolean test_mode, String from_name, String from_email, String subject, String message) throws Exception {
        this.securityProvider.isValid(sessionID, true);
        if (instanceID == null || instanceID.toString() == null) {
            log.warn((Object)"Trying to get instance for null EIURI");
            return false;
        }
        String instanceIDStr = instanceID.toString();
        String host = instanceIDStr.substring(0, instanceIDStr.indexOf("/i/") + 1);
        RepositoryHttpConfig repoConfig = this.mapHostToRepoConfig.get(host);
        if (repoConfig == null) {
            log.error((Object)("Unrecognized resource instance URL:  " + instanceIDStr));
            throw new Exception("Unrecognized resource instance URL:  " + instanceIDStr);
        }
        HttpClient searchHttpClient = this.mapHostToHttpClient.get(host);
        int status = 0;
        PostMethod method = new PostMethod(repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.CONTACT_URL));
        method.setRequestHeader("charset", "UTF-8");
        method.setRequestHeader("format", "application/x-www-form-urlencoded");
        method.setRequestHeader("Referer", repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.CONTACT_URL).replaceFirst("emailContact", "contact") + "?uri=" + URLEncoder.encode(instanceIDStr) + "&safe=" + Boolean.toString(test_mode) + "&label=" + URLEncoder.encode(label));
        method.setParameter("uri", instanceIDStr);
        method.setParameter("label", label);
        if (test_mode) {
            method.setParameter("test_mode", Boolean.toString(test_mode));
        }
        method.setParameter("client_ip", client_ip);
        method.setParameter("from_name", from_name);
        method.setParameter("from_email", from_email);
        method.setParameter("subject", subject);
        method.setParameter("message", message);
        if (isDebugEnabled) {
            log.debug((Object)("Sending contact message " + instanceID.toString()));
        }
        try {
            status = searchHttpClient.executeMethod((HttpMethod)method);
            if (status == 200 || status == 302) {
                boolean bl = true;
                return bl;
            }
            String response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
            log.error((Object)("send contact " + instanceID + " failed with status: " + status + "\r\n" + response));
            boolean bl = false;
            return bl;
        }
        finally {
            method.releaseConnection();
            this.connectionManager.closeIdleConnections(1800000L);
        }
    }

    private class ConnectionReaper
    extends Thread {
        private long SLEEP_INTERVAL = 1800000L;

        public ConnectionReaper() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    ConnectionReaper.sleep(this.SLEEP_INTERVAL);
                }
                catch (InterruptedException e) {
                    return;
                }
                RepositoryInstanceProvider.this.connectionManager.closeIdleConnections(this.SLEEP_INTERVAL);
            }
        }
    }

    protected static enum RestCommands {
        GetNewInstanceIDs("repository/new"),
        WhoAmI("repository/whoami"),
        Logout("repository/logout/"),
        GetInstance("i"),
        UpdateInstance("repository/update"),
        Query("repository/sparql"),
        Online(""),
        Graph("repository/graph"),
        FakeWorkflow("repository/fakeworkflow"),
        Listgraphs("repository/listGraphs"),
        Claim("repository/workflow/claim"),
        Release("repository/workflow/release"),
        Transition("repository/workflow/push"),
        ListTransitions("repository/workflow/transitions"),
        ListResources("repository/workflow/resources");

        private final String key;

        private RestCommands(String propKey) {
            this.key = propKey;
        }

        public String getURL() {
            return this.key;
        }
    }
}

