/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import java.io.Serializable;

public class RepositoryProviderException
extends Exception
implements Serializable {
    private RepositoryProviderExceptionType type;
    private static final long serialVersionUID = 1557653921270297044L;

    public RepositoryProviderException() {
        this(null, null, RepositoryProviderExceptionType.GENERAL);
    }

    public RepositoryProviderException(RepositoryProviderExceptionType type) {
        this(null, null, type);
    }

    public RepositoryProviderException(String message) {
        this(message, null, RepositoryProviderExceptionType.GENERAL);
    }

    public RepositoryProviderException(String message, RepositoryProviderExceptionType type) {
        this(message, null, type);
    }

    public RepositoryProviderException(Throwable cause) {
        this(null, cause, RepositoryProviderExceptionType.GENERAL);
    }

    public RepositoryProviderException(Throwable cause, RepositoryProviderExceptionType type) {
        this(null, cause, type);
    }

    public RepositoryProviderException(String message, Throwable cause) {
        this(message, cause, RepositoryProviderExceptionType.GENERAL);
    }

    public RepositoryProviderException(String message, Throwable cause, RepositoryProviderExceptionType type) {
        super(message, cause);
        this.type = type == null ? RepositoryProviderExceptionType.GENERAL : type;
    }

    @Override
    public String getMessage() {
        if (super.getMessage() == null) {
            return this.type.getMessage();
        }
        return super.getMessage();
    }

    public RepositoryProviderExceptionType getExceptionType() {
        return this.type;
    }

    public static enum RepositoryProviderExceptionType {
        MOVED_PERMANENTLY("Permanent Redirect.", 301),
        MOVED_TEMPORARILY("Temporary Redirect.", 302),
        NOT_FOUND("Repository unavailable.", 404),
        UNAUTHORIZED("Not authorized to get user information (login/whoami).", 401),
        CONFLICT("Probably a stale token.", 409),
        INTERNAL_SERVER_ERROR("Repository internal server error", 500),
        BAD_REQUEST("Bad request.", 400),
        NOT_ACCEPTABLE("Not acceptable request.", 406),
        FORBIDDEN("Repository operation not permitted.", 403),
        GONE("Repository resource is temporarily unavailable.", 410),
        GENERAL("General Failure.", 0),
        INVALID_SESSION("Session is invalid.", 0);

        private final String message;
        private final int status;

        private RepositoryProviderExceptionType(String message, int httpStatus) {
            this.message = message;
            this.status = httpStatus;
        }

        public String getMessage() {
            return this.message;
        }

        public int getHttpStatus() {
            return this.status;
        }

        public static RepositoryProviderExceptionType getTypeFromStatus(int status) {
            RepositoryProviderExceptionType result = null;
            RepositoryProviderExceptionType[] values = RepositoryProviderExceptionType.values();
            for (int i = 0; i < values.length && result == null; ++i) {
                if (values[i].getHttpStatus() != status) continue;
                result = values[i];
            }
            return result;
        }
    }
}

