/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.solr.AbstractLuceneIndexer;

public abstract class AbstractLuceneIndexerNew
implements ResourceChangeListener {
    private static final Log logger = LogFactory.getLog(AbstractLuceneIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    protected String indexerLabel;
    private int count;
    protected EIOntModel eiOntModel;
    protected Analyzer analyzer;
    protected Directory directory;
    private boolean indexEmpty;
    private Map<String, Map<String, Document>> mapFieldToKeyToDocument;
    private Map<String, Set<String>> mapFieldToDeletedKeySet;
    private Set<EIEntity> resourceRoots = new HashSet<EIEntity>();
    private Set<EIEntity> setInsitutionsWithInitialData = new HashSet<EIEntity>();
    private Set<EIURI> flattenTypeURIs = new HashSet<EIURI>();

    public AbstractLuceneIndexerNew(String indexerLabel, EIOntModel eiOntModel, Analyzer analyzer, Directory directory) {
        this.indexerLabel = indexerLabel;
        this.eiOntModel = eiOntModel;
        this.analyzer = analyzer;
        this.directory = directory;
        for (EIClass c : eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            this.resourceRoots.add(c.getEntity());
        }
        this.initFlattenCache();
        this.indexEmpty = true;
    }

    private void initFlattenCache() {
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class")) {
            this.addFlattenClass(c);
        }
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_SearchFlatten")) {
            this.addFlattenClass(c);
        }
    }

    private void addFlattenClass(EIClass c) {
        this.flattenTypeURIs.add(c.getEntity().getURI());
        for (EIClass sub : this.eiOntModel.getSubClasses(c.getEntity().getURI())) {
            this.flattenTypeURIs.add(sub.getEntity().getURI());
        }
    }

    protected boolean isFlattenClass(EIURI uri) {
        return this.flattenTypeURIs.contains(uri);
    }

    protected IndexWriter getWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        return new IndexWriter(this.directory, this.analyzer, IndexWriter.MaxFieldLength.LIMITED);
    }

    public void onChangeStreamStart(EIEntity institution) {
        logger.debug((Object)(this.indexerLabel + ": onChangeStreamStart: " + institution.getLabel()));
        this.count = 0;
    }

    public void onChangeEvent(ResourceChangeEvent event) {
        assert (event != null) : this.indexerLabel + ": Null change event notification";
        ++this.count;
        if (this.count % 500 == 0) {
            logger.debug((Object)(this.indexerLabel + ": Received " + this.count + " change events..."));
        }
    }

    public boolean onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        logger.debug((Object)(this.indexerLabel + ": onChangeStreamEnd: " + institution.getLabel() + "   num change events " + this.count + " last modifed: " + dateFormat.format(lastModifiedDate)));
        return this.commitDocumentCache(institution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean commitDocumentCache(EIEntity institution) {
        boolean success = false;
        IndexWriter iwriter = null;
        try {
            iwriter = this.getWriter();
            if (this.mapFieldToDeletedKeySet != null && !this.indexEmpty) {
                for (String field : this.mapFieldToDeletedKeySet.keySet()) {
                    Set<String> setDeletedKeys = this.mapFieldToDeletedKeySet.get(field);
                    for (String key : setDeletedKeys) {
                        this.deleteDocumentFromIndex(iwriter, field, key);
                    }
                }
            }
            if (this.mapFieldToKeyToDocument == null) return success;
            for (String field : this.mapFieldToKeyToDocument.keySet()) {
                Map<String, Document> mapKeyToDocument = this.mapFieldToKeyToDocument.get(field);
                for (String key : mapKeyToDocument.keySet()) {
                    if (this.setInsitutionsWithInitialData.contains(institution)) {
                        // empty if block
                    }
                    Document doc = mapKeyToDocument.get(key);
                    if (!this.indexEmpty) {
                        this.deleteDocumentFromIndex(iwriter, field, key);
                    }
                    iwriter.addDocument(doc);
                }
            }
            if (institution == null) return success;
            if (this.mapFieldToKeyToDocument.size() <= 0) return success;
            this.indexEmpty = false;
            this.setInsitutionsWithInitialData.add(institution);
            return success;
        }
        catch (Exception e) {
            logger.error((Object)(this.indexerLabel + ": Error updating Documents: indexEmpty: " + this.indexEmpty), (Throwable)e);
            return success;
        }
        finally {
            try {
                if (iwriter != null) {
                    iwriter.close();
                }
                success = true;
                logger.debug((Object)(this.indexerLabel + ": Wrote updated Documents to index."));
            }
            catch (Exception e) {
                logger.error((Object)(this.indexerLabel + ": Error closing IndexWriter after Document update"), (Throwable)e);
                try {
                    if (IndexWriter.isLocked((Directory)this.directory)) {
                        IndexWriter.unlock((Directory)this.directory);
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)(this.indexerLabel + ": Error unlocking after update"), (Throwable)e2);
                }
            }
            finally {
                iwriter = null;
                this.mapFieldToKeyToDocument = null;
                this.mapFieldToDeletedKeySet = null;
            }
        }
    }

    protected Document getDocument(String keyField, String key) {
        Document doc;
        Map<String, Document> mapKeyToDocument;
        if (this.mapFieldToKeyToDocument != null && (mapKeyToDocument = this.mapFieldToKeyToDocument.get(keyField)) != null && (doc = mapKeyToDocument.get(key)) != null) {
            return doc;
        }
        if (!this.indexEmpty && (doc = this.getDocumentFromIndex(keyField, key)) != null) {
            this.setDocument(keyField, key, doc);
            return doc;
        }
        return null;
    }

    protected void setDocument(String keyField, String key, Document doc) {
        Map<String, Document> mapKeyToDocument;
        if (this.mapFieldToKeyToDocument == null) {
            this.mapFieldToKeyToDocument = new HashMap<String, Map<String, Document>>();
        }
        if ((mapKeyToDocument = this.mapFieldToKeyToDocument.get(keyField)) == null) {
            mapKeyToDocument = new HashMap<String, Document>();
            this.mapFieldToKeyToDocument.put(keyField, mapKeyToDocument);
        }
        mapKeyToDocument.put(key, doc);
    }

    protected Document getDocumentFromIndex(String keyField, String key) {
        try {
            TermQuery keyQuery = new TermQuery(new Term(keyField, key));
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            TopDocs docs = searcher.search((Query)keyQuery, 1);
            if (docs.totalHits == 0) {
                return null;
            }
            assert (docs.scoreDocs.length == 1) : "Unique document key wasn't unique: " + key;
            return searcher.doc(docs.scoreDocs[0].doc);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
    }

    protected void deleteDocument(String keyField, String key) {
        Map<String, Document> mapKeyToDocument;
        if (this.mapFieldToKeyToDocument != null && (mapKeyToDocument = this.mapFieldToKeyToDocument.get(keyField)) != null) {
            mapKeyToDocument.remove(key);
        }
        if (!this.indexEmpty) {
            Set<String> deletedKeySet;
            if (this.mapFieldToDeletedKeySet == null) {
                this.mapFieldToDeletedKeySet = new HashMap<String, Set<String>>();
            }
            if ((deletedKeySet = this.mapFieldToDeletedKeySet.get(keyField)) == null) {
                deletedKeySet = new HashSet<String>();
                this.mapFieldToDeletedKeySet.put(keyField, deletedKeySet);
            }
            deletedKeySet.add(key);
        }
    }

    private void deleteDocumentFromIndex(IndexWriter iwriter, String keyField, String key) {
        try {
            TermQuery keyQuery = new TermQuery(new Term(keyField, key));
            iwriter.deleteDocuments((Query)keyQuery);
        }
        catch (IOException e) {
            logger.error((Object)(this.indexerLabel + ": Unexpected error during delete"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        if (this.indexEmpty) {
            return;
        }
        logger.debug((Object)(this.indexerLabel + ": Optimizing index..."));
        IndexWriter iwriter = null;
        try {
            iwriter = this.getWriter();
            iwriter.optimize();
        }
        catch (Exception e) {
            logger.error((Object)(this.indexerLabel + ": Unexpected error during optimize"), (Throwable)e);
        }
        finally {
            try {
                iwriter.close();
                logger.debug((Object)(this.indexerLabel + ": Optimize complete."));
            }
            catch (Exception e) {
                logger.error((Object)(this.indexerLabel + ": Error closing IndexWriter after optimize"), (Throwable)e);
                try {
                    if (IndexWriter.isLocked((Directory)this.directory)) {
                        IndexWriter.unlock((Directory)this.directory);
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)(this.indexerLabel + ": Error unlocking after optimize"), (Throwable)e2);
                }
            }
        }
    }
}

