package org.eaglei.solr.search;

import org.eaglei.solr.LuceneIndexSchema;

public interface LuceneSearchIndexSchema extends LuceneIndexSchema {
	
    float BOOST_URI = 1000.0f;
    
    float BOOST_ENTITY_LABEL = 1.4f;
    float BOOST_ALT_LABEL = 1.4f;
    
    //String FIELD_TYPE_URI = "type_uri";
    //String FIELD_TYPE_LABEL = "type_label";
    
    String FIELD_ASSERTED_TYPE_URI = "asserted_type_uri";
    float BOOST_ASSERTED_TYPE_URI = 8.0f;
    String FIELD_ASSERTED_TYPE_LABEL = "asserted_type_label";
    float BOOST_ASSERTED_TYPE_LABEL = 2.0f;

    String FIELD_INFERRED_TYPE_URI = "inferred_type_uri";
    float BOOST_INFERRED_TYPE_URI = 7.0f;
    String FIELD_INFERRED_TYPE_LABEL = "inferred_type_label";
    float BOOST_INFERRED_TYPE_LABEL = 1.8f;

    String FIELD_PROP_URI = "prop_uri";
    float BOOST_PROP_URI = 7.0f;
    
    String FIELD_PROP_TEXT = "prop_text";
    float BOOST_PROP_TEXT = 1.2f;
    
    String FIELD_DESCRIPTION = "description";
    float BOOST_DESCRIPTION = 1.0f;
    
    String FIELD_REFERENCED_BY = "referenced_by";
    
    String FIELD_PROVIDER_URI = "provider_uri";
    String FIELD_PROVIDER_LABEL = "provider_label";
    String FIELD_PROVIDER_TYPE_URI = "provider_type_uri";
    
    // De-prioritize synonym matches
    float BOOST_SYNONYM = 0.8f;
}
