/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.solr.search.ClassUsageCache;
import org.eaglei.solr.search.LuceneSearchIndexSchema;
import org.eaglei.solr.search.LuceneSearchQueryBuilder;
import org.eaglei.solr.search.LuceneSearchUtil;
import org.eaglei.solr.search.ProviderUsageCache;
import org.eaglei.solr.suggest.LuceneDataSuggestProvider;

public final class LuceneSearchProvider
implements LuceneSearchIndexSchema,
SearchProvider {
    private static final Log logger = LogFactory.getLog(LuceneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final boolean RETRIEVE_PROPERTIES = false;
    private final EIOntModel eagleiOntModel;
    private final InstitutionRegistry institutionRegistry;
    private Directory dir;
    private Analyzer analyzer;
    private LuceneSearchQueryBuilder queryBuilder;
    private ClassUsageCache classUsageCache;
    private ProviderUsageCache providerUsageCache;
    private LuceneDataSuggestProvider suggestProvider;

    public LuceneSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry institutionRegistry, Directory dir, Analyzer analyzer, LuceneSearchQueryBuilder queryBuilder, ClassUsageCache classUsageCache, ProviderUsageCache providerUsageCache, LuceneDataSuggestProvider suggestProvider) {
        assert (dir != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.institutionRegistry = institutionRegistry;
        this.dir = dir;
        this.analyzer = analyzer;
        this.queryBuilder = queryBuilder;
        this.classUsageCache = classUsageCache;
        this.providerUsageCache = providerUsageCache;
        this.suggestProvider = suggestProvider;
    }

    public void init() throws IOException {
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        return this.query(request, true);
    }

    private SearchResultSet query(SearchRequest request, boolean createResults) throws IOException {
        assert (request != null);
        List<String> extractedURIs = Collections.emptyList();
        if (request.getTerm() != null && request.getTerm().getQuery() != null) {
            extractedURIs = this.suggestProvider.extractURIs(request.getTerm().getQuery(), 20);
        }
        Query query = null;
        try {
            query = this.queryBuilder.createQuery(extractedURIs, request);
            if (DEBUG && createResults) {
                logger.debug((Object)("Query: " + query.toString()));
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe.getLocalizedMessage());
        }
        if (query == null) {
            return new SearchResultSet(request);
        }
        return this.executeSearch(request, query, createResults);
    }

    private SearchResultSet executeSearch(SearchRequest request, Query query, boolean createResults) throws IOException {
        SearchResultSet results = new SearchResultSet(request);
        IndexSearcher searcher = new IndexSearcher(this.dir, true);
        searcher.setDefaultFieldSortScoring(true, true);
        TopFieldDocs docs = searcher.search(query, null, request.getStartIndex() + request.getMaxResults(), Sort.RELEVANCE);
        results.setTotalCount(docs.totalHits);
        results.setStartIndex(request.getStartIndex());
        if (!createResults) {
            return results;
        }
        Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(query));
        int cap = request.getStartIndex() + request.getMaxResults();
        for (int i = request.getStartIndex(); i < cap && i < docs.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = docs.scoreDocs[i];
            Document document = searcher.doc(scoreDoc.doc);
            SearchResult result = this.createSearchResultForDocument(searcher, scoreDoc, document);
            if (result == null) continue;
            String highlight = LuceneSearchUtil.computeHighlight(highlighter, this.analyzer, this.eagleiOntModel, request, query, document, result);
            if (highlight != null) {
                result.setHighlight(highlight);
            }
            if (results.getResults().contains(result)) {
                logger.error((Object)"Found duplicate result");
            }
            results.getResults().add(result);
        }
        return results;
    }

    private SearchResult createSearchResultForDocument(IndexSearcher searcher, ScoreDoc scoreDoc, Document document) {
        float score = scoreDoc.score;
        String resource = document.get("uri");
        String label = document.get("entity_label");
        if (label == null) {
            logger.warn((Object)("A stub resource instance w/ no label was included as a search result: " + resource));
            return null;
        }
        EIEntity resourceEntity = EIEntity.create((EIURI)EIURI.create((String)resource), (String)label);
        String institutionURI = document.get("institution_uri");
        EIEntity institutionEntity = this.institutionRegistry.getInstitution(EIURI.create((String)institutionURI));
        String typeURI = document.get("asserted_type_uri");
        String typeLabel = document.get("asserted_type_label");
        EIEntity typeEntity = EIEntity.create((String)typeURI, (String)typeLabel);
        SearchResult result = new SearchResult(resourceEntity, typeEntity, null, institutionEntity);
        this.setResourceProvider(result, document);
        result.setURL(resource);
        result.setRank(score);
        return result;
    }

    private void setResourceProvider(SearchResult result, Document doc) {
        String providerURI = doc.get("provider_uri");
        String providerLabel = doc.get("provider_label");
        if (providerURI != null && providerLabel != null) {
            EIEntity providerEntity = EIEntity.create((String)providerURI, (String)providerLabel);
            result.setProvider(providerEntity);
        }
    }

    public SearchCounts count(SearchCountRequest request) throws IOException {
        throw new RuntimeException("deprecated");
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        ClassCountResult totalCountResult = this.classUsageCache.getClassCount(request);
        if (request.getTerm() == null && request.getProvider() == null && (request.getBinding() == null || request.getBinding().getDataTypeProperties().size() == 0 && request.getBinding().getObjectProperties().size() == 0)) {
            return totalCountResult;
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(new CountResult(totalCountResult.getEntity()));
        try {
            SearchResultSet results = this.query(request, false);
            result.getClassCount().increment(results.getTotalCount());
            SearchRequest countRequest = new SearchRequest(request.toURLParams());
            if (totalCountResult.getSuperClassCounts() != null) {
                ArrayList<CountResult> resultSuperClassCounts = new ArrayList<CountResult>(totalCountResult.getSuperClassCounts().size());
                for (CountResult totalSuperClassCount : totalCountResult.getSuperClassCounts()) {
                    countRequest.setBinding(new SearchRequest.TypeBinding(totalSuperClassCount.getEntity().getURI()));
                    results = this.query(countRequest, false);
                    resultSuperClassCounts.add(new CountResult(totalSuperClassCount.getEntity(), results.getTotalCount()));
                }
                result.setSuperClassCounts(resultSuperClassCounts);
            }
            if (totalCountResult.getSubClassCounts() != null) {
                TreeSet<CountResult> resultSubClassCounts = new TreeSet<CountResult>();
                for (CountResult totalSubClassCount : totalCountResult.getSubClassCounts()) {
                    countRequest.setBinding(new SearchRequest.TypeBinding(totalSubClassCount.getEntity().getURI()));
                    results = this.query(countRequest, false);
                    if (results.getTotalCount() <= 0) continue;
                    resultSubClassCounts.add(new CountResult(totalSubClassCount.getEntity(), results.getTotalCount()));
                }
                result.setSubClassCounts(resultSubClassCounts);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public ClassCountResult getProviderTypeCount(SearchRequest request) {
        ClassCountResult totalCountResult = this.providerUsageCache.getProviderCount(request);
        if (request.getTerm() == null && request.getProvider() == null && request.getBinding() == null) {
            return totalCountResult;
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(new CountResult(totalCountResult.getEntity()));
        try {
            if (totalCountResult.getSubClassCounts() != null) {
                SearchRequest countRequest = new SearchRequest(request.toURLParams());
                TreeSet<CountResult> resultSubClassCounts = new TreeSet<CountResult>();
                for (CountResult totalSubClassCount : totalCountResult.getSubClassCounts()) {
                    countRequest.setProviderType(totalSubClassCount.getEntity().getURI());
                    SearchResultSet results = this.query(countRequest, false);
                    if (results.getTotalCount() <= 0) continue;
                    resultSubClassCounts.add(new CountResult(totalSubClassCount.getEntity(), results.getTotalCount()));
                }
                result.setSubClassCounts(resultSubClassCounts);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return result;
    }
}

