/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.lexical.SuggestionProvider;
import org.eaglei.lexical.lucene.EntityMatchImpl;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.model.EIURI;
import org.eaglei.solr.suggest.LuceneAutoSuggestIndexSchema;

public class LuceneAutoSuggestProvider
implements LuceneAutoSuggestIndexSchema,
SuggestionProvider {
    private static final Log logger = LogFactory.getLog(LuceneAutoSuggestProvider.class);
    public static final float DEFAULT_SCORE_THRESHHOLD = 0.2f;
    public static final int MAX_FRAGMENTS = 4;
    private QueryParser labelParser;
    private Directory directory;
    private Analyzer indexAnalyzer;
    private float scoreThreshold = 0.2f;
    private boolean fuzzyRewrite = false;

    public LuceneAutoSuggestProvider(Analyzer analyzer, Directory directory) throws IOException {
        this(analyzer, analyzer, directory);
    }

    public LuceneAutoSuggestProvider(Analyzer queryAnalyzer, Analyzer indexAnalyzer, Directory directory) throws IOException {
        this.directory = directory;
        this.labelParser = new QueryParser(Version.LUCENE_30, "label", queryAnalyzer);
        this.indexAnalyzer = indexAnalyzer;
    }

    public void setFuzzyRewrite(boolean fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
    }

    public void setScoreThreshold(float threshold) {
        this.scoreThreshold = threshold;
    }

    public List<EntityMatch> suggest(EntityMatchRequest request) throws IOException {
        ArrayList<EntityMatch> matches = new ArrayList<EntityMatch>();
        String text = request.getText();
        if (text == null || text.length() == 0) {
            return matches;
        }
        try {
            Query query = this.parse(request);
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            searcher.setDefaultFieldSortScoring(true, true);
            TopFieldDocs docs = searcher.search(query, null, request.getMaxMatches(), Sort.RELEVANCE);
            if (docs.totalHits == 0 && this.fuzzyRewrite) {
                query = LuceneUtils.rewriteToFuzzy((Query)query);
                docs = searcher.search(query, null, request.getMaxMatches(), Sort.RELEVANCE);
            }
            Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(query));
            for (int i = 0; i < docs.scoreDocs.length && i < request.getMaxMatches(); ++i) {
                ScoreDoc scoreDoc = docs.scoreDocs[i];
                Document document = searcher.doc(scoreDoc.doc);
                float score = scoreDoc.score;
                if (!(this.scoreThreshold <= 0.0f) && !(score >= this.scoreThreshold)) continue;
                String label = document.get("label");
                String highlight = null;
                try {
                    highlight = highlighter.getBestFragment(this.indexAnalyzer, "label", label);
                }
                catch (InvalidTokenOffsetsException itoe) {
                    logger.error((Object)itoe);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                }
                String prefLabel = document.get("entity_label");
                EntityMatchImpl match = new EntityMatchImpl(prefLabel, label, highlight, document.get("uri"), score);
                String rootTypeLabel = document.get("root_type");
                if (rootTypeLabel != null) {
                    match.setRootTypeLabel(rootTypeLabel);
                }
                matches.add((EntityMatch)match);
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
        return matches;
    }

    private Query parse(EntityMatchRequest request) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        String text = request.getText();
        EIURI uri = request.getURI();
        Query labelQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.labelParser, (String)text);
        query.add(labelQuery, BooleanClause.Occur.MUST);
        if (uri != null) {
            PhraseQuery typeQuery = new PhraseQuery();
            typeQuery.add(new Term("type", uri.toString()));
            query.add((Query)typeQuery, BooleanClause.Occur.MUST);
        }
        if (request.getProperty() != null) {
            PhraseQuery propQuery = new PhraseQuery();
            propQuery.add(new Term("is_value_of", request.getProperty()));
            query.add((Query)propQuery, BooleanClause.Occur.MUST);
        }
        return query;
    }
}

