/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.suggest;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.solr.AbstractLuceneIndexerNew;
import org.eaglei.solr.suggest.LuceneDataSuggestIndexSchema;

public class LuceneDataSuggestIndexer
extends AbstractLuceneIndexerNew
implements LuceneDataSuggestIndexSchema,
ResourceChangeListener {
    private static final Log logger = LogFactory.getLog(LuceneDataSuggestIndexer.class);
    private static final EIURI DOCUMENT_URI = EIURI.create((String)"http://purl.obolibrary.org/obo/IAO_0000310");
    private static final EIURI PROTOCOL_URI = EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0000272");
    private Set<EIEntity> categoryRoots = new HashSet<EIEntity>();

    public LuceneDataSuggestIndexer(EIOntModel eiOntModel, Analyzer analyzer, Directory directory) {
        super("DataSuggestIndexer", eiOntModel, analyzer, directory);
        for (EIClass c : eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            this.categoryRoots.add(c.getEntity());
        }
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        super.onChangeEvent(event);
        if (event.isDelete()) {
            this.deleteResourceInstance(event);
        } else {
            this.indexResourceInstance(event);
        }
    }

    private void indexResourceInstance(ResourceChangeEvent event) {
        EIEntity resourceEntity = event.getEntity();
        String resourceURIStr = resourceEntity.getURI().toString();
        EIEntity typeEntity = event.getType();
        if (this.eiOntModel.isSubClass(DOCUMENT_URI, typeEntity.getURI()) && !this.eiOntModel.isSubClass(PROTOCOL_URI, typeEntity.getURI())) {
            return;
        }
        String categoryURIStr = this.getCategory(typeEntity);
        Document doc = this.createEntity(true, resourceURIStr, resourceEntity.getLabel(), categoryURIStr);
        String entitySuggestLabel = doc.get("entity_label");
        this.addLabelReference(entitySuggestLabel, categoryURIStr, doc, null);
        this.addClassReferenceWithSubsumption(typeEntity.getURI().toString(), doc, resourceURIStr, categoryURIStr);
        for (EIObjectProperty prop : event.getObjectProperties()) {
            for (EIURI valueURI : event.getObjectProperty(prop)) {
                this.addPropertyReference(valueURI, doc, resourceURIStr, categoryURIStr);
            }
        }
        if (event.getProvider() != null) {
            EIURI resourceProviderURI = event.getProvider();
            this.addInstanceReference(resourceProviderURI.toString(), doc, resourceURIStr, categoryURIStr);
        }
        this.setDocument("entity_uri", resourceURIStr, doc);
    }

    private Document createEntity(boolean isInstance, String uriStr, String label, String categoryURIStr) {
        Document previousEntityDoc = this.getDocument("entity_uri", uriStr);
        Document entityDoc = new Document();
        entityDoc.add((Fieldable)new Field("entity_uri", uriStr, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        entityDoc.add((Fieldable)new Field("entity_is_instance", Boolean.toString(isInstance), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        if (label != null) {
            label = label.trim().toLowerCase();
            entityDoc.add((Fieldable)new Field("entity_label", label, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        if (categoryURIStr != null) {
            entityDoc.add((Fieldable)new Field("entity_category", categoryURIStr, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        this.setDocument("entity_uri", uriStr, entityDoc);
        if (previousEntityDoc != null && label != null) {
            assert (isInstance);
            String[] referencingURIStrs = previousEntityDoc.getValues("entity_referenced_by");
            if (referencingURIStrs != null) {
                for (String referencingURIStr : referencingURIStrs) {
                    Document referencingDocument = this.getEntityDocument(referencingURIStr);
                    if (referencingDocument == null) {
                        logger.error((Object)(this.indexerLabel + ": " + label + " : " + uriStr + " has referenced_by uri that doesn't exist: " + referencingURIStr));
                        continue;
                    }
                    String referencingCategoryURIStr = referencingDocument.get("entity_category");
                    this.addInstanceReference(uriStr, referencingDocument, referencingURIStr, referencingCategoryURIStr);
                }
            }
        }
        return entityDoc;
    }

    private void addPropertyReference(EIURI referencedURI, Document referencingDocument, String referencingURIStr, String referencingCategoryURIStr) {
        String referencedURIStr = referencedURI.toString();
        if (this.eiOntModel.isModelClassURI(referencedURIStr)) {
            this.addClassReferenceWithSubsumption(referencedURIStr, referencingDocument, referencingURIStr, referencingCategoryURIStr);
        } else {
            this.addInstanceReference(referencedURIStr, referencingDocument, referencingURIStr, referencingCategoryURIStr);
        }
    }

    private void addClassReferenceWithSubsumption(String classURIStr, Document referencingDocument, String referencingURIStr, String referencingCategoryURIStr) {
        EIURI classURI = EIURI.create((String)classURIStr);
        this.addClassReference(classURI, referencingDocument, referencingURIStr, referencingCategoryURIStr);
        List resourceSuperClasses = this.eiOntModel.getSuperClasses(classURI);
        for (EIClass superClass : resourceSuperClasses) {
            this.addClassReference(superClass.getEntity().getURI(), referencingDocument, referencingURIStr, referencingCategoryURIStr);
        }
    }

    private void addClassReference(EIURI classURI, Document referencingDocument, String referencingURIStr, String referencingCategoryURIStr) {
        String[] synonyms;
        String classSuggestLabel;
        Document classDocument = this.getEntityDocument(classURI.toString());
        if (classDocument == null) {
            EIEntity classEntity = this.eiOntModel.getClass(classURI).getEntity();
            classDocument = this.createEntity(false, classEntity.getURI().toString(), classEntity.getLabel(), null);
            classSuggestLabel = classDocument.get("entity_label");
            for (String synonym : this.eiOntModel.getLabels(classURI)) {
                if ((synonym = synonym.trim().toLowerCase()).equals(classSuggestLabel)) continue;
                classDocument.add((Fieldable)new Field("entity_synonym", synonym, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
        classSuggestLabel = classDocument.get("entity_label");
        this.addLabelReference(classSuggestLabel, referencingCategoryURIStr, referencingDocument, classDocument);
        for (String synonym : synonyms = classDocument.getValues("entity_synonym")) {
            this.addLabelReference(synonym, referencingCategoryURIStr, referencingDocument, classDocument);
        }
    }

    private void addInstanceReference(String referencedInstanceURIStr, Document referencingDocument, String referencingURIStr, String referencingCategoryURIStr) {
        Document referencedInstanceDoc = this.getEntityDocument(referencedInstanceURIStr);
        if (referencedInstanceDoc == null) {
            referencedInstanceDoc = this.createEntity(true, referencedInstanceURIStr, null, null);
        }
        this.addReferencedBy(referencedInstanceDoc, referencingURIStr);
        String instanceLabel = referencedInstanceDoc.get("entity_label");
        if (instanceLabel != null) {
            this.addLabelReference(instanceLabel, referencingCategoryURIStr, referencingDocument, null);
        }
    }

    private void addReferencedBy(Document doc, String referencedByURIStr) {
        Field field = new Field("entity_referenced_by", referencedByURIStr, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        doc.add((Fieldable)field);
    }

    private void removeReferencedBy(Document doc, String referencedByURIStr) {
        String[] existingRefByStrs = doc.getValues("entity_referenced_by");
        doc.removeFields("entity_referenced_by");
        boolean foundOne = false;
        for (String existingRefByStr : existingRefByStrs) {
            if (!foundOne && existingRefByStr.equals(referencedByURIStr)) {
                foundOne = true;
                continue;
            }
            this.addReferencedBy(doc, existingRefByStr);
        }
    }

    private void addLabelReference(String label, String instanceCategoryURIStr, Document instanceDocument, Document classDocument) {
        assert (label.equals(label.trim().toLowerCase())) : "Probably called addLabel w/out getting the string from the entity Document";
        assert (instanceCategoryURIStr != null) : "Null category id";
        Document suggestDocument = this.getDocument("suggest_label_key", label);
        if (suggestDocument == null) {
            suggestDocument = new Document();
            suggestDocument.add((Fieldable)new Field("suggest_label_key", label, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            suggestDocument.add((Fieldable)new Field("suggest_label_search", label, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        }
        String[] categories = suggestDocument.getValues("suggest_category");
        boolean alreadyHasCategory = false;
        for (String existingCategory : categories) {
            if (!existingCategory.equals(instanceCategoryURIStr)) continue;
            alreadyHasCategory = true;
            break;
        }
        if (!alreadyHasCategory) {
            suggestDocument.add((Fieldable)new Field("suggest_category", instanceCategoryURIStr, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        instanceDocument.add((Fieldable)new Field("entity_label_reference", label, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        if (classDocument != null) {
            classDocument.add((Fieldable)new Field("entity_label_reference", label, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        this.setDocument("suggest_label_key", label, suggestDocument);
    }

    private Document getEntityDocument(String uriStr) {
        return this.getDocument("entity_uri", uriStr);
    }

    private String getCategory(EIEntity typeEntity) {
        if (this.categoryRoots.contains(typeEntity)) {
            return typeEntity.getURI().toString();
        }
        List resourceSuperClasses = this.eiOntModel.getSuperClasses(typeEntity.getURI());
        for (EIClass superClass : resourceSuperClasses) {
            if (!this.categoryRoots.contains(superClass.getEntity())) continue;
            return superClass.getEntity().getURI().toString();
        }
        return "UnknownCategory";
    }

    private void deleteResourceInstance(ResourceChangeEvent event) {
        String[] referencingURIStrs;
        EIEntity resourceEntity = event.getEntity();
        String uriStr = resourceEntity.getURI().toString();
        Document instanceDoc = this.getDocument("entity_uri", uriStr);
        if (instanceDoc == null) {
            logger.debug((Object)(this.indexerLabel + ": Delete event for entity not found in index: " + uriStr));
            return;
        }
        String instanceLabel = instanceDoc.get("entity_label");
        logger.debug((Object)(this.indexerLabel + ": Deleting: " + instanceLabel + " : " + uriStr));
        if (instanceLabel != null && (referencingURIStrs = instanceDoc.getValues("entity_referenced_by")) != null) {
            for (String referencingURIStr : referencingURIStrs) {
                this.removeInstanceReference(instanceDoc, referencingURIStr);
            }
        }
        String[] labelReferences = instanceDoc.getValues("entity_label_reference");
        String category = instanceDoc.get("entity_category");
        this.deleteDocument("entity_uri", uriStr);
        for (String labelReference : labelReferences) {
            this.removeLabelReference(labelReference, category, instanceDoc);
        }
    }

    private void removeInstanceReference(Document referencedDocument, String referencingURIStr) {
        Document referencingDocument = this.getEntityDocument(referencingURIStr);
        if (referencingDocument == null) {
            logger.error((Object)("removeInstanceReference: referencing document does not exist: " + referencingURIStr));
            return;
        }
        this.removeReferencedBy(referencedDocument, referencingURIStr);
        String label = referencedDocument.get("entity_label");
        if (label == null) {
            logger.warn((Object)("removeInstanceReference called for referenced document with null label: " + referencedDocument.get("entity_uri")));
            return;
        }
        String[] labelReferences = referencingDocument.getValues("entity_label_reference");
        referencingDocument.removeFields("entity_label_reference");
        boolean foundOne = false;
        logger.debug((Object)("  Remove use of label " + label + " from referencing document: " + referencingDocument.get("entity_label")));
        for (String labelReference : labelReferences) {
            if (!foundOne && labelReference.equals(label)) {
                foundOne = true;
                logger.debug((Object)("     label use: " + labelReference + "  [removed]"));
                continue;
            }
            referencingDocument.add((Fieldable)new Field("entity_label_reference", labelReference, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            logger.debug((Object)("     label use: " + labelReference));
        }
        String category = referencingDocument.get("entity_category");
        if (category == null) {
            logger.error((Object)("removeInstanceReference: category of referencing doc should not be null: " + referencingURIStr));
            return;
        }
        this.removeLabelReference(label, category, referencingDocument);
    }

    private void removeLabelReference(String label, String category, Document referencingDocument) {
        if (!this.isLabelReference(label, category)) {
            Document suggestDocument = this.getDocument("suggest_label_key", label);
            String[] suggestDocumentCategories = suggestDocument.getValues("suggest_category");
            suggestDocument.removeFields("suggest_category");
            logger.debug((Object)("No use of label [" + label + "] in category: " + category));
            for (String existingCategory : suggestDocumentCategories) {
                if (existingCategory.equals(category)) {
                    logger.debug((Object)("          category " + existingCategory + "  [removed]"));
                    continue;
                }
                logger.debug((Object)("          category " + existingCategory));
                suggestDocument.add((Fieldable)new Field("suggest_category", existingCategory, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            if (suggestDocument.getValues("suggest_category").length == 0) {
                logger.debug((Object)("No use of label in any category: " + label));
                this.deleteDocument("suggest_label_key", label);
            }
        }
    }

    private boolean isLabelReference(String label, String category) {
        this.commitDocumentCache(null);
        try {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("entity_is_instance", Boolean.toString(true))), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("entity_label_reference", label)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("entity_category", category)), BooleanClause.Occur.MUST);
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            TopDocs docs = searcher.search((Query)query, 1);
            logger.debug((Object)("isLabelReference: label:" + label + "  category:" + category + "  " + (docs.totalHits > 0)));
            return docs.totalHits > 0;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return true;
        }
    }
}

