/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.lexical.SuggestionProvider;
import org.eaglei.lexical.lucene.EntityMatchImpl;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.solr.suggest.LuceneDataSuggestIndexSchema;

public class LuceneDataSuggestProvider
implements LuceneDataSuggestIndexSchema,
SuggestionProvider {
    private static final Log logger = LogFactory.getLog(LuceneDataSuggestProvider.class);
    public static final float DEFAULT_SCORE_THRESHHOLD = 0.7f;
    public static final int MAX_FRAGMENTS = 4;
    private Directory directory;
    private Analyzer indexAnalyzer;
    final Analyzer queryAnalyzer;
    private float scoreThreshold = 0.7f;

    public LuceneDataSuggestProvider(Analyzer analyzer, Directory directory) throws IOException {
        this(analyzer, analyzer, directory);
    }

    public LuceneDataSuggestProvider(Analyzer queryAnalyzer, Analyzer indexAnalyzer, Directory directory) throws IOException {
        this.directory = directory;
        this.queryAnalyzer = queryAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
    }

    public void setScoreThreshold(float threshold) {
        this.scoreThreshold = threshold;
    }

    public List<EntityMatch> suggest(EntityMatchRequest request) throws IOException {
        ArrayList<EntityMatch> matches = new ArrayList<EntityMatch>();
        String queryStr = request.getText().toLowerCase();
        if (queryStr.length() == 0) {
            return matches;
        }
        try {
            EntityMatch match;
            int i;
            Query labelQuery;
            IndexSearcher searcher = new IndexSearcher(this.directory);
            searcher.setDefaultFieldSortScoring(true, false);
            BooleanQuery query = new BooleanQuery();
            String text = request.getText();
            QueryParser labelParser = new QueryParser(Version.LUCENE_30, "suggest_label_search", this.queryAnalyzer);
            try {
                labelQuery = LuceneUtils.escapeIfInvalid((QueryParser)labelParser, (String)text);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                return matches;
            }
            query.add(labelQuery, BooleanClause.Occur.MUST);
            TopDocs hits = searcher.search((Query)query, request.getMaxMatches());
            QueryScorer scorer = new QueryScorer((Query)query, "suggest_label_search");
            Highlighter highlighter = new Highlighter((Scorer)scorer);
            ArrayList<EntityMatchImpl> startWith = new ArrayList<EntityMatchImpl>(request.getMaxMatches());
            ArrayList<EntityMatchImpl> notStartWith = new ArrayList<EntityMatchImpl>(request.getMaxMatches());
            HashMap<String, Document> mapLabelToDoc = new HashMap<String, Document>();
            for (i = 0; i < hits.scoreDocs.length && matches.size() < request.getMaxMatches(); ++i) {
                String fragment;
                ScoreDoc scoreDoc = hits.scoreDocs[i];
                float score = scoreDoc.score;
                if (!(this.scoreThreshold <= 0.0f) && !(score >= this.scoreThreshold)) continue;
                Document doc = searcher.doc(scoreDoc.doc);
                TokenStream stream = TokenSources.getAnyTokenStream((IndexReader)searcher.getIndexReader(), (int)scoreDoc.doc, (String)"suggest_label_search", (Document)doc, (Analyzer)this.queryAnalyzer);
                String label = doc.get("suggest_label_key");
                mapLabelToDoc.put(label, doc);
                try {
                    fragment = highlighter.getBestFragment(stream, label);
                }
                catch (InvalidTokenOffsetsException e) {
                    logger.error((Object)("Error generating highlight: " + request.toString()), (Throwable)e);
                    continue;
                }
                EntityMatchImpl match2 = new EntityMatchImpl(label, label, fragment, null, score);
                if (!label.startsWith(queryStr)) {
                    notStartWith.add(match2);
                    continue;
                }
                startWith.add(match2);
            }
            for (i = 0; matches.size() < request.getMaxMatches() && i < startWith.size(); ++i) {
                match = (EntityMatch)startWith.get(i);
                matches.add(match);
                if (matches.size() != 1) continue;
                this.addCategorySuggest(matches, match, (Document)mapLabelToDoc.get(match.getMatchLabel()));
            }
            for (i = 0; matches.size() < request.getMaxMatches() && i < notStartWith.size(); ++i) {
                match = (EntityMatch)notStartWith.get(i);
                matches.add(match);
                if (matches.size() != 1) continue;
                this.addCategorySuggest(matches, match, (Document)mapLabelToDoc.get(match.getMatchLabel()));
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error generating suggestions: " + request.toString()), (Throwable)e);
        }
        return matches;
    }

    private void addCategorySuggest(List<EntityMatch> matches, EntityMatch matchRoot, Document doc) {
        String[] categories;
        for (String category : categories = doc.getValues("suggest_category")) {
            if (category.equals("UnknownCategory")) continue;
            EntityMatchImpl match = new EntityMatchImpl(matchRoot.getMatchLabel(), matchRoot.getMatchLabel(), matchRoot.getHighlight(), null, matchRoot.getScore());
            match.setBindingType(category);
            matches.add((EntityMatch)match);
        }
    }

    public List<String> extractURIs(String queryStr, int max) {
        if ((queryStr = queryStr.trim().toLowerCase()).length() == 0) {
            return Collections.emptyList();
        }
        try {
            int i;
            ArrayList<String> results = new ArrayList<String>(max);
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            TermQuery query = new TermQuery(new Term("entity_label", queryStr));
            TopDocs docs = searcher.search((Query)query, max);
            for (i = 0; i < docs.scoreDocs.length; ++i) {
                results.add(searcher.doc(docs.scoreDocs[i].doc).get("entity_uri"));
            }
            if (results.size() < max) {
                query = new TermQuery(new Term("entity_synonym", queryStr));
                docs = searcher.search((Query)query, max);
                for (i = 0; i < docs.scoreDocs.length && results.size() < max; ++i) {
                    results.add(searcher.doc(docs.scoreDocs[i].doc).get("entity_uri"));
                }
            }
            return results;
        }
        catch (IOException e) {
            logger.error((Object)("Error extracting URIs: " + queryStr), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

