/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.suggest.client.SelectionListener;

public abstract class OntologyDropdownBase
extends Composite
implements ClickHandler,
MouseOverHandler,
MouseOutHandler {
    protected final HorizontalPanel p = new HorizontalPanel();
    protected final Image image = new Image("images/ontology.png");
    protected final PushButton button = new PushButton(new Image("images/drop_arrow.png"));
    protected PopupPanel popup;
    protected ScrollPanel scroll;
    protected Tree tree;
    protected EIClass rootClass;
    protected boolean rootListLoading;
    protected SelectionListener listener;
    protected ResourceTreeWidget currentItemHover;

    protected abstract void populateChildList(TreeItem var1);

    protected abstract void populateChildList(TreeItem var1, ResourceTreeWidget var2, List<EIClass> var3);

    protected abstract void doOnClick(ClickEvent var1);

    protected void init() {
        this.p.setStyleName("OntologyDropdown");
        this.image.setStyleName("OntologyDropdown-Image");
        this.image.addMouseOverHandler((MouseOverHandler)this);
        this.image.addMouseOutHandler((MouseOutHandler)this);
        this.p.add((Widget)this.image);
        this.p.setCellWidth((Widget)this.image, "100%");
        this.button.setStyleName("OntologyDropdown-DropButton");
        this.button.addMouseOverHandler((MouseOverHandler)this);
        this.button.addMouseOutHandler((MouseOutHandler)this);
        this.p.add((Widget)this.button);
        this.initWidget((Widget)this.p);
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                OntologyDropdownBase.this.popup = new PopupPanel(true);
                OntologyDropdownBase.this.popup.setStyleName("OntologyDropdown-PopupPanel");
                OntologyDropdownBase.this.scroll = new ScrollPanel();
                OntologyDropdownBase.this.tree = new Tree();
                OntologyDropdownBase.this.tree.setAnimationEnabled(true);
                OntologyDropdownBase.this.tree.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

                    public void onOpen(OpenEvent<TreeItem> event) {
                        ResourceTreeWidget w = (ResourceTreeWidget)((TreeItem)event.getTarget()).getWidget();
                        if (w.getResource().hasSubClass() && w.childListLoading) {
                            OntologyDropdownBase.this.populateChildList((TreeItem)event.getTarget());
                        } else {
                            OntologyDropdownBase.this.setPopupHeight();
                        }
                    }
                });
                OntologyDropdownBase.this.tree.addCloseHandler((CloseHandler)new CloseHandler<TreeItem>(){

                    public void onClose(CloseEvent<TreeItem> event) {
                        OntologyDropdownBase.this.setPopupHeight();
                    }
                });
                OntologyDropdownBase.this.scroll.setWidget((Widget)OntologyDropdownBase.this.tree);
                OntologyDropdownBase.this.popup.setWidget((Widget)OntologyDropdownBase.this.scroll);
                OntologyDropdownBase.this.popup.addAutoHidePartner((Element)OntologyDropdownBase.this.image.getElement());
                OntologyDropdownBase.this.popup.addAutoHidePartner((Element)OntologyDropdownBase.this.button.getElement());
                OntologyDropdownBase.this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        OntologyDropdownBase.this.handlePopupClose();
                    }
                });
                OntologyDropdownBase.this.image.addClickHandler((ClickHandler)OntologyDropdownBase.this);
                OntologyDropdownBase.this.button.addClickHandler((ClickHandler)OntologyDropdownBase.this);
            }
        });
    }

    public void onClick(ClickEvent event) {
        this.doOnClick(event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    private void handleSelection(EIClass resource) {
        this.listener.onSelection(resource);
        this.popup.hide();
    }

    public void onMouseOver(MouseOverEvent event) {
    }

    public void onMouseOut(MouseOutEvent event) {
    }

    private void handlePopupClose() {
        if (this.currentItemHover != null) {
            this.currentItemHover.l.removeStyleDependentName("hovering");
        }
    }

    public void setResource(EIClass resource) {
        this.rootClass = resource;
        if (this.tree != null) {
            this.tree.clear();
            this.scroll.getElement().getStyle().clearHeight();
        }
        if (this.rootClass.hasSubClass()) {
            if (this.tree != null) {
                // empty if block
            }
            this.rootListLoading = true;
        } else if (this.tree != null) {
            this.tree.addItem("No types are available");
        }
    }

    private void setPopupHeight() {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                int maxHeight;
                int h = OntologyDropdownBase.this.tree.getOffsetHeight();
                if (h > (maxHeight = OntologyDropdownBase.this.computeMaxHeight())) {
                    OntologyDropdownBase.this.scroll.setHeight(maxHeight + "px");
                } else {
                    OntologyDropdownBase.this.scroll.getElement().getStyle().clearHeight();
                }
                OntologyDropdownBase.this.popup.showRelativeTo((UIObject)OntologyDropdownBase.this.p);
            }
        });
    }

    private int computeMaxHeight() {
        int top = this.p.getAbsoluteTop();
        int windowTop = Window.getScrollTop();
        int windowBottom = Window.getScrollTop() + Window.getClientHeight();
        int distanceFromWindowTop = top - windowTop;
        int distanceToWindowBottom = windowBottom - (top + this.p.getOffsetHeight());
        if (distanceToWindowBottom > 200) {
            return distanceToWindowBottom - 10;
        }
        if (distanceFromWindowTop > 200) {
            return distanceFromWindowTop - 10;
        }
        return distanceToWindowBottom > distanceFromWindowTop ? distanceToWindowBottom - 10 : distanceFromWindowTop - 10;
    }

    protected class ResourceTreeWidget
    extends Composite
    implements MouseOverHandler,
    MouseOutHandler,
    ClickHandler {
        EIClass resource;
        Label l;
        public boolean childListLoading;

        public ResourceTreeWidget(EIClass resource) {
            this.resource = resource;
            this.l = new Label(resource.getEntity().getLabel());
            this.l.setStyleName("ResourceTreeItem");
            this.l.addMouseOverHandler((MouseOverHandler)this);
            this.l.addMouseOutHandler((MouseOutHandler)this);
            this.l.addClickHandler((ClickHandler)this);
            this.initWidget((Widget)this.l);
        }

        public void onMouseOver(MouseOverEvent event) {
            this.l.addStyleDependentName("hovering");
            OntologyDropdownBase.this.currentItemHover = this;
        }

        public void onMouseOut(MouseOutEvent event) {
            this.l.removeStyleDependentName("hovering");
        }

        public void onClick(ClickEvent event) {
            OntologyDropdownBase.this.handleSelection(this.resource);
        }

        public EIClass getResource() {
            return this.resource;
        }
    }
}

