/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.lexical.EntityExtractionProvider;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.model.EIURI;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SuggestionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(SuggestionServlet.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    private EntityExtractionProvider eagleiModelSuggestionProvider;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.eagleiModelSuggestionProvider = (EntityExtractionProvider)ctx.getBean("eagleiModelSuggestionProvider", EntityExtractionProvider.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        String classid = request.getParameter("classid");
        String q = request.getParameter("q");
        q = q.substring(1, q.length() - 1);
        String asyncCallback = request.getParameter("callback");
        List suggestions = null;
        EntityMatchRequest entityRequest = null;
        if (classid == null) {
            entityRequest = new EntityMatchRequest(q);
        } else {
            String decodedClassId = URLDecoder.decode(classid);
            logger.info((Object)("Getting suggestions for class id: " + decodedClassId));
            entityRequest = new EntityMatchRequest(q, EIURI.create((String)decodedClassId));
        }
        entityRequest.setMaxMatches(10);
        suggestions = this.eagleiModelSuggestionProvider.match(entityRequest);
        StringBuilder sb = new StringBuilder();
        sb.append(asyncCallback);
        sb.append("({");
        SuggestionServlet.writeJsonNameValueString(sb, "id", id);
        sb.append(',');
        sb.append("suggestions");
        sb.append(":[");
        if (suggestions != null && suggestions.size() > 0) {
            int i = 0;
            while (true) {
                EntityMatch suggestion = (EntityMatch)suggestions.get(i++);
                sb.append("\"");
                sb.append(suggestion.getHighlight());
                sb.append("\"");
                sb.append(',');
                SuggestionServlet.writeJsonValueString(sb, suggestion.getMatchLabel());
                sb.append(',');
                SuggestionServlet.writeJsonValueString(sb, suggestion.getEntity().getURI().toString());
                if (i == suggestions.size()) break;
                sb.append(',');
            }
        }
        sb.append("]");
        sb.append("})");
        String output = sb.toString();
        response.setContentType("text/javascript");
        response.addHeader("Pragma", "no-cache");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        out.println(output);
    }

    private static void writeJsonNameValueString(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        SuggestionServlet.writeJsonValueString(sb, value);
    }

    private static void writeJsonValueString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
    }
}

